/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Properties;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.CallContext;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.Msg;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static URL getResource(String search) throws MissingResourceException {
        return ResourceUtil.getResource(CallContext.instance().getCallingClass(), search);
    }

    public static URL getResource(Class clazz, String resourceName) throws MissingResourceException {
        URL resource = new CWClassLoader(clazz).findResource(resourceName);
        if (resource == null) {
            throw new MissingResourceException(Msg.NO_RESOURCE.toString(resourceName), clazz.getName(), resourceName);
        }
        return resource;
    }

    public static InputStream getResourceAsStream(String search) throws IOException, MissingResourceException {
        return ResourceUtil.getResourceAsStream(CallContext.instance().getCallingClass(), search);
    }

    public static InputStream getResourceAsStream(Class clazz, String search) throws IOException, MissingResourceException {
        URL url = ResourceUtil.getResource(clazz, search);
        return url.openStream();
    }

    public static Properties getProperties(String subject) throws IOException, MissingResourceException {
        return ResourceUtil.getProperties(CallContext.instance().getCallingClass(), subject);
    }

    public static Properties getProperties(Class clazz) throws IOException, MissingResourceException {
        return ResourceUtil.getProperties(clazz, ClassUtil.getShortClassName(clazz));
    }

    private static Properties getProperties(Class clazz, String subject) throws IOException, MissingResourceException {
        String lookup = subject + ".properties";
        InputStream in = ResourceUtil.getResourceAsStream(clazz, lookup);
        Properties prop = new Properties();
        prop.load(in);
        return prop;
    }
}

