/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.install.InstallerFactory;
import org.crosswire.jsword.book.install.sword.FtpSwordInstaller;
import org.crosswire.jsword.book.install.sword.Msg;

public class FtpSwordInstallerFactory
implements InstallerFactory {
    public Installer createInstaller() {
        return new FtpSwordInstaller();
    }

    public Installer createInstaller(String url) {
        String[] parts = url.split("/", 4);
        if (parts.length < 4) {
            throw new IllegalArgumentException(Msg.INVALID_URL.toString(url));
        }
        FtpSwordInstaller reply = new FtpSwordInstaller();
        String part2 = parts[2];
        if (part2.indexOf("@") >= 0) {
            String[] chop2 = part2.split("@");
            if (chop2.length != 2) {
                throw new IllegalArgumentException(Msg.URL_AT_COUNT.toString(url));
            }
            String[] chop3 = chop2[0].split(":");
            if (chop3.length != 2) {
                throw new IllegalArgumentException(Msg.URL_COLON_COUNT.toString(url));
            }
            reply.setUsername(chop3[0]);
            reply.setPassword(chop3[1]);
            reply.setHost(chop2[1]);
        } else {
            reply.setHost(part2);
        }
        reply.setDirectory("/" + parts[3]);
        return reply;
    }
}

