/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.search.parse;

import java.util.Collection;
import java.util.Iterator;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.SentanceUtil;
import org.crosswire.jsword.book.search.Grammar;
import org.crosswire.jsword.book.search.Thesaurus;
import org.crosswire.jsword.book.search.ThesaurusFactory;
import org.crosswire.jsword.book.search.parse.IndexSearcher;
import org.crosswire.jsword.book.search.parse.Msg;
import org.crosswire.jsword.book.search.parse.ParamWord;
import org.crosswire.jsword.book.search.parse.Word;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.RestrictionType;

public class PhraseParamWord
implements ParamWord {
    private Thesaurus thesaurus;
    private static final int BLUR_BY = 2;

    public String getWord(IndexSearcher engine) throws BookException {
        throw new BookException(Msg.SINGLE_PARAM);
    }

    public Key getKeyList(IndexSearcher engine) throws BookException {
        Iterator it = engine.iterator();
        StringBuffer buff = new StringBuffer();
        while (true) {
            if (!it.hasNext()) {
                throw new BookException(Msg.LEFT_BRACKETS);
            }
            Word word = (Word)it.next();
            if (word instanceof PhraseParamWord) break;
            buff.append(word);
            buff.append(" ");
        }
        return this.bestMatch(engine, buff.toString());
    }

    public Key bestMatch(IndexSearcher engine, String sought) throws BookException {
        int i;
        if (this.thesaurus == null) {
            try {
                this.thesaurus = ThesaurusFactory.createThesaurus();
            }
            catch (InstantiationException ex) {
                throw new BookException((MsgBase)Msg.NO_THESAURUS, ex);
            }
        }
        String[] words = SentanceUtil.getWords(sought);
        words = Grammar.stripSmallWords(words);
        PassageTally tally = new PassageTally();
        tally.blur(2, RestrictionType.NONE);
        for (i = 0; i < words.length; ++i) {
            tally.addAll(engine.getIndex().findWord(words[i]));
        }
        for (i = 0; i < words.length; ++i) {
            Collection col = this.thesaurus.getSynonyms(words[i]);
            String[] grWords = col.toArray(new String[col.size()]);
            PassageTally temp = new PassageTally();
            for (int j = 0; j < grWords.length; ++j) {
                temp.addAll(engine.getIndex().findWord(grWords[j]));
            }
            temp.flatten();
            tally.addAll(temp);
        }
        return tally;
    }
}

