/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.Msg;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.GuiConvert;

public class ColorField
extends JPanel
implements Field {
    private static final String EDIT = "EditColor";
    private ActionFactory actions;
    protected Color color = Color.white;
    private static final int SIZE = 16;
    private static final long serialVersionUID = 3617291237934053686L;

    public ColorField() {
        this.actions = new ActionFactory(ColorField.class, this);
        JButton edit = new JButton(this.actions.getAction(EDIT));
        edit.setIcon(new CustomIcon());
        edit.setMargin(new Insets(1, 2, 1, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)edit, "West");
    }

    public void doEditColor() {
        this.color = JColorChooser.showDialog(this, Msg.EDIT.toString(), this.color);
    }

    public void setChoice(Choice param) {
    }

    public String getValue() {
        return GuiConvert.color2String(this.color);
    }

    public void setValue(String value) {
        this.color = GuiConvert.string2Color(value);
    }

    public JComponent getComponent() {
        return this;
    }

    class CustomIcon
    implements Icon {
        CustomIcon() {
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (ColorField.this.color == null) {
                g.setColor(Color.black);
                g.drawRect(x, y, 16, 16);
                g.drawLine(x, y, x + 16, y + 16);
                g.drawLine(x + 16, y, x, y + 16);
            } else {
                g.setColor(ColorField.this.color);
                g.fillRect(x, y, 16, 16);
                g.setColor(Color.black);
                g.drawRect(x, y, 16, 16);
            }
        }
    }
}

