/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.progress.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.WorkEvent;
import org.crosswire.common.progress.WorkListener;
import org.crosswire.common.progress.swing.Msg;
import org.crosswire.common.util.Logger;

public class JobsViewPane
extends JPanel
implements WorkListener {
    protected Map jobs;
    private List positions;
    private JPanel jobsPanel;
    private JLabel noJobLabel;
    private static final Logger log = Logger.getLogger(JobsViewPane.class);
    private static final long serialVersionUID = 3546366136561315891L;

    public JobsViewPane() {
        this.init();
        JobManager.addWorkListener(this);
        Set current = JobManager.getJobs();
        Iterator it = current.iterator();
        while (it.hasNext()) {
            Job job = (Job)it.next();
            this.addJob(job);
        }
    }

    private void init() {
        this.noJobLabel = new JLabel(Msg.NO_JOBS.toString());
        this.jobs = new HashMap();
        this.positions = new ArrayList();
        this.jobsPanel = new JPanel(new GridBagLayout());
        this.jobsPanel.setBorder(null);
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.jobsPanel, "North");
        JScrollPane scrollPane = new JScrollPane(pnl);
        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.setPreferredSize(new Dimension(500, 300));
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.add((Component)new JPanel(), "South");
        this.add((Component)new JPanel(), "East");
        this.add((Component)new JPanel(), "West");
        this.add((Component)new JPanel(), "North");
    }

    public synchronized void workProgressed(final WorkEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Job job = ev.getJob();
                if (!JobsViewPane.this.jobs.containsKey(job)) {
                    if (JobsViewPane.this.jobs.isEmpty()) {
                        JobsViewPane.this.removeEmptyLabel();
                    }
                    JobsViewPane.this.addJob(job);
                }
                JobsViewPane.this.updateJob(job);
                if (job.isFinished()) {
                    JobsViewPane.this.removeJob(job);
                    if (JobsViewPane.this.jobs.isEmpty()) {
                        JobsViewPane.this.addEmptyLabel();
                    }
                }
            }
        });
    }

    protected void addJob(final Job job) {
        int i = this.findEmptyPosition();
        log.debug("adding job to panel at " + i + ": " + job.getJobDescription());
        JProgressBar progress = new JProgressBar();
        progress.setStringPainted(true);
        progress.setString("0%");
        progress.setToolTipText(job.getJobDescription());
        progress.setValue(0);
        JLabel label = new JLabel(job.getJobDescription() + ":");
        JButton cancel = new JButton(Msg.CANCEL.toString());
        if (!job.isInterruptable()) {
            cancel.setEnabled(false);
        }
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                job.interrupt();
            }
        });
        this.jobsPanel.add((Component)label, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jobsPanel.add((Component)progress, new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jobsPanel.add((Component)cancel, new GridBagConstraints(2, i, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.revalidate();
        JobData jobdata = new JobData(job, i, label, progress, cancel);
        this.jobs.put(job, jobdata);
        if (i >= this.positions.size()) {
            this.positions.add(jobdata);
        } else {
            this.positions.set(i, jobdata);
        }
    }

    protected void updateJob(Job job) {
        JobData jobdata = (JobData)this.jobs.get(job);
        int percent = job.getPercent();
        jobdata.getProgress().setString(percent + "%");
        jobdata.getProgress().setToolTipText(job.getStateDescription());
        jobdata.getProgress().setValue(percent);
    }

    protected void removeJob(Job job) {
        JobData jobdata = (JobData)this.jobs.get(job);
        log.debug("removing job from panel at " + jobdata.getIndex() + ": " + job.getJobDescription());
        this.positions.set(jobdata.getIndex(), null);
        this.jobs.remove(job);
        this.jobsPanel.remove(jobdata.getLabel());
        this.jobsPanel.remove(jobdata.getProgress());
        this.jobsPanel.remove(jobdata.getCancel());
        this.revalidate();
        jobdata.invalidate();
    }

    protected void addEmptyLabel() {
        this.jobsPanel.add((Component)this.noJobLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.revalidate();
    }

    protected void removeEmptyLabel() {
        this.jobsPanel.remove(this.noJobLabel);
        this.revalidate();
    }

    private int findEmptyPosition() {
        int i;
        for (i = 0; i < this.positions.size() && this.positions.get(i) != null; ++i) {
        }
        return i;
    }

    private static class JobData {
        private Job job;
        private JLabel label;
        private JProgressBar progress;
        private JButton cancel;
        private int index = -1;

        public JobData(Job job, int index, JLabel label, JProgressBar progress, JButton cancel) {
            this.job = job;
            this.index = index;
            this.label = label;
            this.progress = progress;
            this.cancel = cancel;
        }

        void invalidate() {
            this.job = null;
            this.label = null;
            this.progress = null;
            this.cancel = null;
            this.index = -1;
        }

        Job getJob() {
            return this.job;
        }

        JLabel getLabel() {
            return this.label;
        }

        JProgressBar getProgress() {
            return this.progress;
        }

        JButton getCancel() {
            return this.cancel;
        }

        int getIndex() {
            return this.index;
        }
    }
}

