/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Component;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.crosswire.common.swing.FieldLayout;
import org.crosswire.common.swing.GuiUtil;

public class FormPane
extends JPanel {
    private static final String SUFFIX_COMP = "_comp";
    private static final String SUFFIX_LABEL = "_label";
    private static final long serialVersionUID = 3258135738867790641L;
    protected Hashtable comps = new Hashtable();

    public FormPane() {
        this.setLayout(new FieldLayout(15, 20));
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public void addEntry(String prompt, Component comp) {
        JLabel label = new JLabel(prompt);
        this.add(label);
        this.add(comp);
        this.comps.put(prompt + SUFFIX_LABEL, label);
        this.comps.put(prompt + SUFFIX_COMP, comp);
    }

    public void removeEntry(String prompt) {
        JLabel label = (JLabel)this.comps.get(prompt + SUFFIX_LABEL);
        Component comp = (Component)this.comps.get(prompt + SUFFIX_COMP);
        this.remove(label);
        this.remove(comp);
        this.comps.remove(prompt + SUFFIX_LABEL);
        this.comps.remove(prompt + SUFFIX_COMP);
    }

    public boolean isEmpty() {
        return this.comps.size() == 0;
    }

    public String[] getFieldNames() {
        int count = this.getComponentCount() / 2;
        String[] list = new String[count];
        for (int i = 0; i < count; ++i) {
            JLabel label = (JLabel)this.getComponent(i * 2);
            list[i] = label.getText();
        }
        return list;
    }

    public String[] getFieldValues() {
        int count = this.getComponentCount() / 2;
        String[] list = new String[count];
        for (int i = 0; i < count; ++i) {
            Component comp = this.getComponent(i * 2 + 1);
            list[i] = GuiUtil.getText(comp);
        }
        return list;
    }
}

