/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.crosswire.bibledesktop.book.DisplaySelectEvent;
import org.crosswire.bibledesktop.book.DisplaySelectListener;
import org.crosswire.bibledesktop.book.DisplaySelectPane;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.bibledesktop.display.splitlist.SplitBookDataDisplay;
import org.crosswire.bibledesktop.display.tab.TabbedBookDataDisplay;
import org.crosswire.bibledesktop.passage.KeySidebar;
import org.crosswire.common.swing.desktop.Clearable;
import org.crosswire.common.swing.desktop.Titleable;
import org.crosswire.common.swing.desktop.event.TitleChangedEvent;
import org.crosswire.common.swing.desktop.event.TitleChangedListener;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageKeyFactory;

public class BibleViewPane
extends JPanel
implements Titleable,
Clearable {
    protected File saved;
    private transient List listeners;
    private DisplaySelectPane pnlSelect;
    protected SplitBookDataDisplay pnlPassg;
    private JFileChooser chooser = new JFileChooser();
    private static final String EXTENSION = ".lst";
    protected static final Logger log;
    private static final long serialVersionUID = 3258415036346282038L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BibleViewPane() {
        this.pnlSelect = new DisplaySelectPane();
        KeySidebar sidebar = new KeySidebar(this.pnlSelect.getBook());
        TabbedBookDataDisplay display = new TabbedBookDataDisplay();
        this.pnlPassg = new SplitBookDataDisplay(sidebar, display);
        sidebar.addKeyChangeListener(this.pnlSelect);
        this.pnlSelect.addCommandListener(sidebar);
        this.pnlPassg.addKeyChangeListener(sidebar);
        this.init();
    }

    private void init() {
        this.chooser.setFileSelectionMode(0);
        this.chooser.addChoosableFileFilter(new CustomFileFilter());
        this.chooser.setMultiSelectionEnabled(false);
        this.pnlSelect.addCommandListener(new DisplaySelectListener(){

            public void passageSelected(DisplaySelectEvent ev) {
                BibleViewPane.this.setKey(ev.getKey());
            }

            public void bookChosen(DisplaySelectEvent ev) {
                BibleViewPane.this.pnlPassg.setBookData(ev.getBook(), ev.getKey());
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlSelect, "North");
        this.add((Component)this.pnlPassg, "Center");
    }

    public void clear() {
        this.saved = null;
        if (!this.pnlSelect.isClear()) {
            this.pnlSelect.clear();
        }
    }

    public boolean isClear() {
        this.saved = null;
        return this.pnlSelect.isClear();
    }

    public String getTitle() {
        if (this.saved == null) {
            return this.pnlSelect.getTitle();
        }
        return this.saved.getName();
    }

    public void save() throws IOException {
        Key key = this.getKey();
        if (key == null) {
            return;
        }
        if (this.saved == null && !this.querySaveFile()) {
            return;
        }
        this.saveKey(key);
    }

    public void saveAs() throws IOException {
        Key key = this.getKey();
        if (key == null) {
            return;
        }
        this.querySaveFile();
        this.saveKey(key);
    }

    private void saveKey(Key key) throws IOException {
        if (!$assertionsDisabled && this.saved == null) {
            throw new AssertionError();
        }
        FileWriter out = new FileWriter(this.saved);
        if (key instanceof Passage) {
            Passage ref = (Passage)key;
            ref.writeDescription((Writer)out);
        } else {
            out.write(key.getName());
            out.write("\n");
        }
        ((Writer)out).close();
    }

    public boolean maySave() {
        return this.getKey() != null;
    }

    public void open() throws NoSuchVerseException, IOException {
        int reply = this.chooser.showOpenDialog(this.getRootPane());
        if (reply == 0) {
            this.saved = this.chooser.getSelectedFile();
            if (this.saved.length() == 0L) {
                Reporter.informUser((Object)this.getRootPane(), (MsgBase)Msg.EMPTY_FILE, (Object)this.saved.getName());
                return;
            }
            FileReader in = new FileReader(this.saved);
            Passage ref = PassageKeyFactory.readPassage((Reader)in);
            this.setKey((Key)ref);
            ((Reader)in).close();
        }
    }

    private boolean querySaveFile() {
        if (this.saved == null) {
            File guess = new File(this.getTitle() + EXTENSION);
            this.chooser.setSelectedFile(guess);
        } else {
            this.chooser.setSelectedFile(this.saved);
        }
        int reply = this.chooser.showSaveDialog(this.getRootPane());
        if (reply == 0) {
            this.saved = this.chooser.getSelectedFile();
            return true;
        }
        return false;
    }

    public Key getKey() {
        return this.pnlPassg.getKey();
    }

    public void setKey(Key key) {
        this.pnlSelect.setTitle(key.getName());
        this.pnlPassg.setBookData(this.pnlSelect.getBook(), key);
        if (this.saved == null) {
            this.fireTitleChanged(new TitleChangedEvent((Object)this, this.getTitle()));
        }
    }

    public SplitBookDataDisplay getPassagePane() {
        return this.pnlPassg;
    }

    public DisplaySelectPane getSelectPane() {
        return this.pnlSelect;
    }

    public synchronized void addTitleChangedListener(TitleChangedListener li) {
        ArrayList<TitleChangedListener> temp = new ArrayList<TitleChangedListener>();
        if (this.listeners == null) {
            temp.add(li);
            this.listeners = temp;
        } else {
            temp.addAll(this.listeners);
            if (!temp.contains(li)) {
                temp.add(li);
                this.listeners = temp;
            }
        }
    }

    public synchronized void removeTitleChangedListener(TitleChangedListener li) {
        if (this.listeners != null && this.listeners.contains(li)) {
            ArrayList temp = new ArrayList();
            temp.addAll(this.listeners);
            temp.remove(li);
            this.listeners = temp;
        }
    }

    protected void fireTitleChanged(TitleChangedEvent ev) {
        if (this.listeners != null) {
            List temp = this.listeners;
            int count = temp.size();
            for (int i = 0; i < count; ++i) {
                ((TitleChangedListener)temp.get(i)).titleChanged(ev);
            }
        }
    }

    static {
        $assertionsDisabled = !BibleViewPane.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)BibleViewPane.class);
    }

    private static final class CustomFileFilter
    extends FileFilter {
        private CustomFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(BibleViewPane.EXTENSION);
        }

        public String getDescription() {
            return Msg.VERSE_LIST_DESC.toString(BibleViewPane.EXTENSION);
        }
    }
}

