/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.crosswire.bibledesktop.book.AdvancedSearchPane;
import org.crosswire.bibledesktop.book.BookListCellRenderer;
import org.crosswire.bibledesktop.book.BooksComboBoxModel;
import org.crosswire.bibledesktop.book.DisplaySelectEvent;
import org.crosswire.bibledesktop.book.DisplaySelectListener;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.bibledesktop.book.PassageSelectionPane;
import org.crosswire.bibledesktop.book.install.IndexResolver;
import org.crosswire.bibledesktop.passage.KeyChangeEvent;
import org.crosswire.bibledesktop.passage.KeyChangeListener;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.QuickHelpDialog;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.IndexStatus;
import org.crosswire.jsword.book.search.parse.IndexSearcher;
import org.crosswire.jsword.book.search.parse.PhraseParamWord;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.RestrictionType;

public class DisplaySelectPane
extends JPanel
implements KeyChangeListener {
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            DisplaySelectPane.this.enableComponents();
        }
    };
    private static final String VIEW_LABEL = "ViewLabel";
    private static final String PASSAGE_FIELD = "PassageAction";
    private static final String MORE = "More";
    private static final String GO_PASSAGE = "GoPassage";
    private static final String HELP = "HelpAction";
    private static final String SEARCH_LABEL = "SearchLabel";
    private static final String GO_SEARCH = "GoSearch";
    private static final String SEARCH_FIELD = "SearchAction";
    private static final String ADVANCED = "Advanced";
    private static final String MATCH = "Match";
    private static final String BIBLE = "Bible";
    private static final String INDEX = "Index";
    private static final ImageIcon ICON_SELECT = GuiUtil.getIcon((String)"toolbarButtonGraphics/general/Edit16.gif");
    private static int base = 1;
    private String title;
    private transient List listeners;
    private QuickHelpDialog dlgHelp;
    private ActionFactory actions;
    private Book selected;
    private BooksComboBoxModel mdlBible;
    private PassageSelectionPane dlgSelect;
    private JTextField txtKey;
    private JTextField txtSearch;
    private JCheckBox chkMatch;
    private JButton btnAdvanced;
    private JButton btnSearch;
    private JButton btnKey;
    private JButton btnKeyGo;
    private AdvancedSearchPane advanced;
    private JButton btnIndex;
    private static final long serialVersionUID = 3256446910616057650L;

    public DisplaySelectPane() {
        this.initialize();
    }

    private void initialize() {
        this.advanced = new AdvancedSearchPane();
        this.title = Msg.UNTITLED.toString(new Integer(base++));
        this.actions = new ActionFactory(DisplaySelectPane.class, (Object)this);
        this.mdlBible = new BooksComboBoxModel(BookFilters.getBibles());
        JComboBox<String> cboBible = new JComboBox<String>(this.mdlBible);
        this.selected = this.mdlBible.getSelectedBook();
        if (this.selected != null) {
            this.selected.addPropertyChangeListener(this.pcl);
            cboBible.setToolTipText(this.selected.toString());
        } else {
            cboBible.setPrototypeDisplayValue("                                                            ");
        }
        cboBible.setRenderer(new BookListCellRenderer());
        cboBible.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 1) {
                    DisplaySelectPane.this.changeVersion();
                    JComboBox combo = (JComboBox)ev.getSource();
                    combo.setToolTipText(combo.getSelectedItem().toString());
                }
            }
        });
        cboBible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cbo = (JComboBox)e.getSource();
                if (cbo.getSelectedIndex() == -1 && cbo.getItemCount() > 0) {
                    cbo.setSelectedIndex(0);
                }
            }
        });
        JLabel lblBible = this.actions.createJLabel(BIBLE);
        lblBible.setLabelFor(cboBible);
        JPanel pnlBible = new JPanel();
        pnlBible.setLayout(new BorderLayout());
        pnlBible.add((Component)lblBible, "West");
        pnlBible.add(cboBible, "East");
        JLabel lblKey = this.actions.createJLabel(VIEW_LABEL);
        this.txtKey = new JTextField();
        this.txtKey.setAction(this.actions.getAction(PASSAGE_FIELD));
        this.txtKey.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent ev) {
                if (ev.getKeyChar() == '\n' && ev.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                    DisplaySelectPane.this.showSelectDialog();
                }
            }
        });
        this.btnKey = new JButton(this.actions.getAction(MORE));
        this.btnKey.setIcon(ICON_SELECT);
        this.btnKey.setBorderPainted(false);
        this.btnKeyGo = new JButton(this.actions.getAction(GO_PASSAGE));
        this.txtSearch = new JTextField();
        this.txtSearch.setAction(this.actions.getAction(SEARCH_FIELD));
        JLabel lblSearch = this.actions.createJLabel(SEARCH_LABEL);
        lblSearch.setLabelFor(this.txtSearch);
        this.btnSearch = new JButton(this.actions.getAction(GO_SEARCH));
        JButton btnHelp = new JButton(this.actions.getAction(HELP));
        btnHelp.setBorder(BorderFactory.createLineBorder(SystemColor.control, 5));
        btnHelp.setBackground(Color.yellow);
        btnHelp.setText(null);
        this.dlgHelp = new QuickHelpDialog(GuiUtil.getFrame((Component)this), Msg.HELP_TITLE.toString(), Msg.HELP_TEXT.toString());
        this.btnAdvanced = new JButton(this.actions.getAction(ADVANCED));
        this.btnAdvanced.setBorderPainted(false);
        this.btnIndex = new JButton(this.actions.getAction(INDEX));
        this.chkMatch = new JCheckBox(this.actions.getAction(MATCH));
        this.setLayout(new GridBagLayout());
        this.add((Component)pnlBible, new GridBagConstraints(0, 0, 6, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)lblKey, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.txtKey, new GridBagConstraints(2, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
        this.add((Component)this.btnKey, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.btnKeyGo, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)btnHelp, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)lblSearch, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.btnIndex, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtSearch, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.chkMatch, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.btnAdvanced, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.btnSearch, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 2, 2), 0, 0));
        this.enableComponents();
    }

    public Book getBook() {
        return this.mdlBible.getSelectedBook();
    }

    public void clear() {
        if (this.isClear()) {
            return;
        }
        this.txtKey.setText("");
        this.txtSearch.setText("");
        this.title = Msg.UNTITLED.toString(new Integer(base++));
        this.updateDisplay();
    }

    public boolean isClear() {
        return this.title.indexOf(Msg.CLEAR.toString()) != -1;
    }

    public void doMore() {
        this.showSelectDialog();
    }

    public void doGoPassage() {
        this.doPassageAction();
    }

    public void doGoSearch() {
        this.doSearchAction();
    }

    public void doPassageAction() {
        this.setTitle(this.txtKey.getText());
        this.updateDisplay();
    }

    public void doSearchAction() {
        Book book = this.mdlBible.getSelectedBook();
        if (book == null) {
            this.noBookInstalled();
            return;
        }
        try {
            Key key;
            String param = this.txtSearch.getText();
            if (this.chkMatch.isSelected()) {
                String quote = IndexSearcher.getPreferredSyntax((Class)PhraseParamWord.class);
                param = quote + param + quote;
            }
            if ((key = book.find(param)) instanceof PassageTally) {
                if (this.chkMatch.isSelected()) {
                    PassageTally tally = (PassageTally)key;
                    tally.setOrdering(1);
                    tally.trimRanges(20, RestrictionType.NONE);
                } else {
                    Key newKey = book.createEmptyKeyList();
                    newKey.addAll(key);
                }
            }
            this.txtKey.setText(key.getName());
            this.setTitle(param);
            this.updateDisplay();
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    public void doAdvanced() {
        String reply = this.advanced.showInDialog(this, Msg.ADVANCED_TITLE.toString(), true, this.txtSearch.getText());
        if (reply != null) {
            this.txtSearch.setText(reply);
        }
    }

    public void doMatch() {
    }

    public void doHelpAction() {
        this.dlgHelp.setVisible(true);
    }

    public void doIndex() {
        if (this.selected == null) {
            this.noBookInstalled();
            return;
        }
        IndexResolver.scheduleIndex(this.selected, this);
        this.enableComponents();
    }

    private void updateDisplay() {
        Book book = this.mdlBible.getSelectedBook();
        if (book == null) {
            this.noBookInstalled();
            return;
        }
        try {
            Key key = book.getKey(this.txtKey.getText());
            this.fireCommandMade(new DisplaySelectEvent(this, key, book));
        }
        catch (NoSuchVerseException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), Msg.BAD_VERSE.toString(), 0);
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setText(String text) {
        String currentText = this.txtKey.getText();
        if (!currentText.equals(text)) {
            this.txtKey.setText(text);
            this.setTitle(text);
            this.updateDisplay();
        }
    }

    protected void changeVersion() {
        Book newSelected = this.mdlBible.getSelectedBook();
        if (this.selected != null && this.selected != newSelected) {
            this.selected.removePropertyChangeListener(this.pcl);
            newSelected.addPropertyChangeListener(this.pcl);
        }
        this.selected = newSelected;
        this.enableComponents();
        if (this.selected == null) {
            this.noBookInstalled();
            return;
        }
        try {
            Key key = this.selected.getKey(this.txtKey.getText());
            this.fireVersionChanged(new DisplaySelectEvent(this, key, this.selected));
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    private void noBookInstalled() {
        String noBible = Msg.NO_INSTALLED_BIBLE.toString();
        JOptionPane.showMessageDialog(this, noBible, noBible, 2);
    }

    protected void enableComponents() {
        boolean readable = this.selected != null;
        boolean searchable = readable && this.selected.getIndexStatus().equals((Object)IndexStatus.DONE);
        boolean indexable = readable && this.selected.getIndexStatus().equals((Object)IndexStatus.UNDONE);
        this.txtSearch.setEnabled(searchable);
        this.txtSearch.setBackground(searchable ? SystemColor.text : SystemColor.control);
        this.txtSearch.setVisible(searchable);
        this.chkMatch.setEnabled(searchable);
        this.btnAdvanced.setEnabled(searchable);
        this.btnSearch.setEnabled(searchable);
        this.txtKey.setEnabled(readable);
        this.txtKey.setBackground(readable ? SystemColor.text : SystemColor.control);
        this.btnKey.setEnabled(readable);
        this.btnKeyGo.setEnabled(readable);
        this.btnIndex.setVisible(indexable);
        this.btnIndex.setEnabled(indexable);
    }

    protected void showSelectDialog() {
        String passg;
        if (this.dlgSelect == null) {
            this.dlgSelect = new PassageSelectionPane();
        }
        if ((passg = this.dlgSelect.showInDialog(this, Msg.SELECT_PASSAGE_TITLE.toString(), true, this.txtKey.getText())) != null) {
            this.txtKey.setText(passg);
            this.doPassageAction();
        }
    }

    public void keyChanged(KeyChangeEvent ev) {
        String text = ev.getKey().getName();
        this.setText(text);
    }

    public synchronized void addCommandListener(DisplaySelectListener li) {
        ArrayList<DisplaySelectListener> temp = new ArrayList<DisplaySelectListener>(2);
        if (this.listeners != null) {
            temp.addAll(this.listeners);
        }
        if (!temp.contains(li)) {
            temp.add(li);
            this.listeners = temp;
        }
    }

    public synchronized void removeCommandListener(DisplaySelectListener li) {
        if (this.listeners != null && this.listeners.contains(li)) {
            ArrayList temp = new ArrayList();
            temp.addAll(this.listeners);
            temp.remove(li);
            this.listeners = temp;
        }
    }

    protected void fireCommandMade(DisplaySelectEvent ev) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                DisplaySelectListener li = (DisplaySelectListener)this.listeners.get(i);
                li.passageSelected(ev);
            }
        }
    }

    protected void fireVersionChanged(DisplaySelectEvent ev) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            for (int i = 0; i < count; ++i) {
                ((DisplaySelectListener)this.listeners.get(i)).bookChosen(ev);
            }
        }
    }
}

