/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.crosswire.bibledesktop.passage.VerseRangeTreeNode;
import org.crosswire.common.util.IteratorEnumeration;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageEvent;
import org.crosswire.jsword.passage.PassageListener;
import org.crosswire.jsword.passage.RestrictionType;

public class PassageTreeNode
implements TreeNode,
PassageListener {
    protected Passage ref;
    protected JTree tree;

    public PassageTreeNode(Passage ref, JTree tree) {
        this.ref = ref;
        this.tree = tree;
        ref.addPassageListener((PassageListener)this);
    }

    public TreeNode getChildAt(int index) {
        return new VerseRangeTreeNode(this.ref.getRangeAt(index, RestrictionType.CHAPTER));
    }

    public int getChildCount() {
        return this.ref.countRanges(RestrictionType.CHAPTER);
    }

    public TreeNode getParent() {
        return this;
    }

    public int getIndex(TreeNode node) {
        int count = 0;
        Iterator it = this.ref.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            if (it.next() == node) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return false;
    }

    public void versesAdded(PassageEvent ev) {
    }

    public void versesRemoved(PassageEvent ev) {
    }

    public void versesChanged(PassageEvent ev) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.nodeStructureChanged(this);
    }

    public Enumeration children() {
        return new IteratorEnumeration(this.ref.rangeIterator(RestrictionType.NONE));
    }

    public String toString() {
        return this.ref.getOverview();
    }
}

