/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.CollectionUtil;
import org.crosswire.common.util.EventListenerList;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilterIterator;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.BookList;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.BookSet;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.Msg;

public final class Books
implements BookList {
    private BookSet books = new BookSet();
    private Set drivers = new HashSet();
    private EventListenerList listeners = new EventListenerList();
    private boolean threaded = false;
    protected static final Logger log = Logger.getLogger((Class)Books.class);
    private static final Books instance = new Books();

    private Books() {
        this.initialize(this.threaded);
    }

    public static Books installed() {
        return instance;
    }

    public synchronized List getBooks() {
        return new BookSet((Collection)((Object)this.books));
    }

    public synchronized Book getBook(String name) {
        Book book;
        Iterator it = this.books.iterator();
        while (it.hasNext()) {
            book = (Book)it.next();
            if (!name.equals(book.getName())) continue;
            return book;
        }
        it = this.books.iterator();
        while (it.hasNext()) {
            book = (Book)it.next();
            if (!name.equalsIgnoreCase(book.getName())) continue;
            return book;
        }
        it = this.books.iterator();
        while (it.hasNext()) {
            book = (Book)it.next();
            BookMetaData bmd = book.getBookMetaData();
            if (!name.equals(bmd.getInitials())) continue;
            return book;
        }
        it = this.books.iterator();
        while (it.hasNext()) {
            book = (Book)it.next();
            if (!name.equalsIgnoreCase(book.getInitials())) continue;
            return book;
        }
        return null;
    }

    public synchronized List getBooks(BookFilter filter) {
        List temp = CollectionUtil.createList((Iterator)new BookFilterIterator(this.getBooks().iterator(), filter));
        return new BookSet(temp);
    }

    public synchronized void addBooksListener(BooksListener li) {
        this.listeners.add(BooksListener.class, (EventListener)li);
    }

    public synchronized void removeBooksListener(BooksListener li) {
        this.listeners.remove(BooksListener.class, (EventListener)li);
    }

    protected synchronized void fireBooksChanged(Object source, Book book, boolean added) {
        Object[] contents = this.listeners.getListenerList();
        BooksEvent ev = null;
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != (class$org$crosswire$jsword$book$BooksListener == null ? Books.class$("org.crosswire.jsword.book.BooksListener") : class$org$crosswire$jsword$book$BooksListener)) continue;
            if (ev == null) {
                ev = new BooksEvent(source, book, added);
            }
            if (added) {
                ((BooksListener)contents[i + 1]).bookAdded(ev);
                continue;
            }
            ((BooksListener)contents[i + 1]).bookRemoved(ev);
        }
    }

    public synchronized void addBook(Book book) {
        if (!this.books.contains(book)) {
            this.books.add(book);
            this.fireBooksChanged(instance, book, true);
        }
    }

    public synchronized void removeBook(Book book) throws BookException {
        Activator.deactivate((Activatable)book);
        boolean removed = this.books.remove(book);
        if (!removed) {
            throw new BookException(Msg.BOOK_NOREMOVE);
        }
        this.fireBooksChanged(instance, book, true);
    }

    public synchronized void registerDriver(BookDriver driver) throws BookException {
        log.debug("begin registering driver: " + driver.getClass().getName());
        this.drivers.add(driver);
        Book[] bookArray = driver.getBooks();
        Set current = CollectionUtil.createSet((Iterator)new BookFilterIterator(this.getBooks().iterator(), BookFilters.getBooksByDriver(driver)));
        for (int j = 0; j < bookArray.length; ++j) {
            Book b = bookArray[j];
            if (current.contains(b)) {
                current.remove(b);
                continue;
            }
            this.addBook(bookArray[j]);
        }
        Iterator iter = current.iterator();
        while (iter.hasNext()) {
            this.removeBook((Book)iter.next());
        }
        log.debug("end registering driver: " + driver.getClass().getName());
    }

    public synchronized void unregisterDriver(BookDriver driver) throws BookException {
        log.debug("begin un-registering driver: " + driver.getClass().getName());
        Book[] bookArray = driver.getBooks();
        for (int j = 0; j < bookArray.length; ++j) {
            this.removeBook(bookArray[j]);
        }
        if (!this.drivers.remove(driver)) {
            throw new BookException((MsgBase)Msg.DRIVER_NOREMOVE, new Object[]{driver.getClass().getName()});
        }
        log.debug("end un-registering driver: " + driver.getClass().getName());
    }

    public synchronized BookDriver[] getDriversByClass(Class type) {
        ArrayList<BookDriver> matches = new ArrayList<BookDriver>();
        Iterator it = this.drivers.iterator();
        while (it.hasNext()) {
            BookDriver driver = (BookDriver)it.next();
            if (driver.getClass() != type) continue;
            matches.add(driver);
        }
        return matches.toArray(new BookDriver[matches.size()]);
    }

    public synchronized BookDriver[] getDrivers() {
        return this.drivers.toArray(new BookDriver[this.drivers.size()]);
    }

    public synchronized BookDriver[] getWritableDrivers() {
        int i = 0;
        Iterator it = this.drivers.iterator();
        while (it.hasNext()) {
            BookDriver driver = (BookDriver)it.next();
            if (!driver.isWritable()) continue;
            ++i;
        }
        BookDriver[] reply = new BookDriver[i];
        i = 0;
        Iterator it2 = this.drivers.iterator();
        while (it2.hasNext()) {
            BookDriver driver = (BookDriver)it2.next();
            if (!driver.isWritable()) continue;
            reply[i++] = driver;
        }
        return reply;
    }

    private void initialize(boolean doThreading) {
        if (doThreading) {
            Runnable runner = new Runnable(){

                public void run() {
                    Books.this.autoRegister();
                }
            };
            Thread init = new Thread(runner, "book-driver-registration");
            init.setPriority(1);
            init.start();
        } else {
            this.autoRegister();
        }
    }

    protected void autoRegister() {
        try {
            Class[] types = ClassUtil.getImplementors((Class)BookDriver.class);
            log.debug("begin auto-registering " + types.length + " drivers:");
            for (int i = 0; i < types.length; ++i) {
                try {
                    Method driverInstance = types[i].getMethod("instance", new Class[0]);
                    BookDriver driver = (BookDriver)driverInstance.invoke(null, new Object[0]);
                    this.registerDriver(driver);
                    continue;
                }
                catch (Exception ex) {
                    Reporter.informUser((Object)(class$org$crosswire$jsword$book$Books == null ? Books.class$("org.crosswire.jsword.book.Books") : class$org$crosswire$jsword$book$Books), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            log.debug("Unexpected exception: " + ex);
        }
    }
}

