/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.gbf;

import java.util.LinkedList;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.filter.gbf.AbstractTag;
import org.crosswire.jsword.book.filter.gbf.Msg;
import org.crosswire.jsword.passage.KeyFactory;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public final class GBFTags {
    protected static final KeyFactory KEY_FACTORY = PassageKeyFactory.instance();
    protected static final OSISUtil.ObjectFactory OSIS_FACTORY = OSISUtil.factory();

    public static final class UnderlineStartTag
    extends AbstractTag {
        public UnderlineStartTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element hi = OSIS_FACTORY.createHI();
            hi.setAttribute("type", "underline");
            Element current = (Element)stack.get(0);
            current.addContent((Content)hi);
            stack.addFirst(hi);
        }
    }

    public static final class TitleStartTag
    extends AbstractTag {
        public TitleStartTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element title = OSIS_FACTORY.createTitle();
            Element current = (Element)stack.get(0);
            current.addContent((Content)title);
            stack.addFirst(title);
        }
    }

    public static final class TextTag
    extends AbstractTag {
        public TextTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            if (stack.size() == 0) {
                stack.addFirst(this.getName());
            } else {
                Element ele = (Element)stack.get(0);
                ele.addContent(this.getName());
            }
        }
    }

    public static final class TextFootnoteTag
    extends AbstractTag {
        public TextFootnoteTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element note = OSIS_FACTORY.createNote();
            note.setAttribute("type", "x-StudyNote");
            Element current = (Element)stack.get(0);
            current.addContent((Content)note);
            stack.addFirst(note);
        }
    }

    public static final class StrongsWordTag
    extends AbstractTag {
        public StrongsWordTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            String name = this.getName().trim();
            Element ele = (Element)stack.get(0);
            int size = ele.getContentSize();
            if (size == 0) {
                DataPolice.report("No content to attach word to: <" + name + ">.");
                return;
            }
            int lastIndex = size - 1;
            Content prevObj = ele.getContent(lastIndex);
            Element word = null;
            if (prevObj instanceof Text) {
                Text textItem = (Text)prevObj;
                word = OSIS_FACTORY.createW();
                ele.removeContent((Content)textItem);
                word.addContent((Content)textItem);
                ele.addContent((Content)word);
            } else if (prevObj instanceof Element) {
                word = (Element)prevObj;
            } else {
                DataPolice.report("No words to attach word to: <" + name + ">.");
                return;
            }
            String existingLemma = word.getAttributeValue("lemma");
            StringBuffer newLemma = new StringBuffer();
            if (existingLemma != null && existingLemma.length() > 0) {
                newLemma.append(existingLemma).append('|');
            }
            newLemma.append("strong:").append(name.substring(2));
            word.setAttribute("lemma", newLemma.toString());
        }
    }

    public static final class StrongsMorphTag
    extends AbstractTag {
        public StrongsMorphTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            String name = this.getName().trim();
            Element ele = (Element)stack.get(0);
            int size = ele.getContentSize();
            if (size == 0) {
                DataPolice.report("No content to attach word to: <" + name + ">.");
                return;
            }
            int lastIndex = size - 1;
            Content prevObj = ele.getContent(lastIndex);
            Element word = null;
            if (prevObj instanceof Text) {
                word = OSIS_FACTORY.createW();
                ele.removeContent(prevObj);
                word.addContent(prevObj);
                ele.addContent((Content)word);
            } else if (prevObj instanceof Element) {
                word = (Element)prevObj;
            } else {
                DataPolice.report("No words to attach word to: <" + name + ">.");
                return;
            }
            String existingMorph = word.getAttributeValue("morph");
            StringBuffer newMorph = new StringBuffer();
            if (existingMorph != null && existingMorph.length() > 0) {
                newMorph.append(existingMorph).append('|');
            }
            newMorph.append("x-StrongsMorph:T").append(name.substring(2));
            word.setAttribute("morph", newMorph.toString());
        }
    }

    public static final class RedLetterStartTag
    extends AbstractTag {
        public RedLetterStartTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element speaker = OSIS_FACTORY.createSpeaker();
            speaker.setAttribute("who", Msg.NAME_JESUS.toString());
            Element current = (Element)stack.get(0);
            current.addContent((Content)speaker);
            stack.addFirst(speaker);
        }
    }

    public static final class PsalmStartTag
    extends AbstractTag {
        public PsalmStartTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element title = OSIS_FACTORY.createTitle();
            Element current = (Element)stack.get(0);
            current.addContent((Content)title);
            stack.addFirst(title);
        }
    }

    public static final class PoetryStartTag
    extends AbstractTag {
        public PoetryStartTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element speech = OSIS_FACTORY.createLG();
            Element current = (Element)stack.get(0);
            current.addContent((Content)speech);
            stack.addFirst(speech);
        }
    }

    public static final class ParagraphTag
    extends AbstractTag {
        public ParagraphTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            if (stack.size() == 0) {
                Element p = OSIS_FACTORY.createLB();
                stack.addFirst(p);
            } else {
                Element p = OSIS_FACTORY.createP();
                Element ele = (Element)stack.get(0);
                ele.addContent((Content)p);
            }
        }
    }

    public static final class OTQuoteStartTag
    extends AbstractTag {
        public OTQuoteStartTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element q = OSIS_FACTORY.createQ();
            Element current = (Element)stack.get(0);
            current.addContent((Content)q);
            stack.addFirst(q);
        }
    }

    public static final class JustifyLeftTag
    extends AbstractTag {
        public JustifyLeftTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
        }
    }

    public static final class JustifyRightTag
    extends AbstractTag {
        public JustifyRightTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element seg = OSIS_FACTORY.createSeg();
            seg.setAttribute("type", "text-align: right;");
            Element current = (Element)stack.get(0);
            current.addContent((Content)seg);
            stack.addFirst(seg);
        }
    }

    public static final class ItalicStartTag
    extends AbstractTag {
        public ItalicStartTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element hi = OSIS_FACTORY.createHI();
            hi.setAttribute("type", "italic");
            Element current = (Element)stack.get(0);
            current.addContent((Content)hi);
            stack.addFirst(hi);
        }
    }

    public static final class IgnoredTag
    extends AbstractTag {
        public IgnoredTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
        }
    }

    public static final class HeaderStartTag
    extends AbstractTag {
        public HeaderStartTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element title = OSIS_FACTORY.createTitle();
            Element current = (Element)stack.get(0);
            current.addContent((Content)title);
            stack.addFirst(title);
        }
    }

    public static final class FootnoteEndTag
    extends AbstractTag {
        public FootnoteEndTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Object pop = stack.removeFirst();
            if (pop instanceof Element) {
                Element note = (Element)pop;
                if (note.getContentSize() < 1) {
                    Element ele = (Element)stack.get(0);
                    ele.removeContent((Content)note);
                }
            } else {
                DataPolice.report("expected to pop a Note, but found " + ClassUtil.getShortClassName(pop.getClass()));
            }
        }
    }

    public static final class FootnoteStartTag
    extends AbstractTag {
        public FootnoteStartTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element current = (Element)stack.get(0);
            Element note = OSIS_FACTORY.createNote();
            note.setAttribute("type", "x-StudyNote");
            current.addContent((Content)note);
            stack.addFirst(note);
        }
    }

    public static final class EOLTag
    extends AbstractTag {
        public EOLTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            if (stack.size() == 0) {
                Element p = OSIS_FACTORY.createLB();
                stack.addFirst(p);
            } else {
                Element p = OSIS_FACTORY.createP();
                Element ele = (Element)stack.get(0);
                ele.addContent((Content)p);
            }
        }
    }

    public static final class CrossRefStartTag
    extends AbstractTag {
        public CrossRefStartTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element seg = OSIS_FACTORY.createReference();
            String refstr = this.getName().substring(2);
            try {
                Passage ref = (Passage)KEY_FACTORY.getKey(refstr);
                seg.setAttribute("osisRef", ref.getOsisRef());
            }
            catch (NoSuchKeyException ex) {
                DataPolice.report("unable to parse reference: " + refstr);
            }
            Element current = (Element)stack.get(0);
            current.addContent((Content)seg);
            stack.addFirst(seg);
        }
    }

    public static final class BoldStartTag
    extends AbstractTag {
        public BoldStartTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            Element hi = OSIS_FACTORY.createHI();
            hi.setAttribute("type", "bold");
            Element current = (Element)stack.get(0);
            current.addContent((Content)hi);
            stack.addFirst(hi);
        }
    }

    public static final class DefaultEndTag
    extends AbstractTag {
        public DefaultEndTag(String name) {
            super(name);
        }

        public void updateOsisStack(LinkedList stack) {
            stack.removeFirst();
        }
    }
}

