/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.Msg;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.util.Convert;

public class PathField
extends JPanel
implements Field {
    private static final String ADD = "AddPathEntry";
    private static final String REMOVE = "RemovePathEntry";
    private static final String UPDATE = "UpdatePathEntry";
    private transient ActionFactory actions;
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private JList list = new JList(this.model);
    private static final long serialVersionUID = 3256443607736072242L;

    public PathField() {
        this.actions = new ActionFactory(PathField.class, this);
        JPanel buttons = new JPanel(new FlowLayout());
        this.list.setFont(new Font("Monospaced", 0, 12));
        this.list.setSelectionMode(0);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.list);
        buttons.add(new JButton(this.actions.getAction(ADD)));
        buttons.add(new JButton(this.actions.getAction(REMOVE)));
        buttons.add(new JButton(this.actions.getAction(UPDATE)));
        TitledBorder title = BorderFactory.createTitledBorder(Msg.PATH_EDITOR.toString());
        Border pad = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setBorder(BorderFactory.createCompoundBorder(title, pad));
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        this.add((Component)buttons, "Last");
    }

    public void setChoice(Choice param) {
    }

    public String getValue() {
        return Convert.stringArray2String(this.getArray(), File.pathSeparator);
    }

    public String[] getArray() {
        String[] retcode = new String[this.model.getSize()];
        for (int i = 0; i < retcode.length; ++i) {
            retcode[i] = (String)this.model.getElementAt(i);
        }
        return retcode;
    }

    public void setValue(String value) {
        this.setArray(Convert.string2StringArray(value, File.pathSeparator));
    }

    public void setArray(String[] value) {
        this.model = new DefaultComboBoxModel<String>(value);
        this.list.setModel(this.model);
    }

    public JComponent getComponent() {
        return this;
    }

    public void doAddPathEntry() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            String path = chooser.getSelectedFile().getPath();
            this.model.addElement(path);
        }
    }

    public void doUpdatePathEntry() {
        JFileChooser chooser = new JFileChooser(this.currentValue());
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            String path = chooser.getSelectedFile().getPath();
            this.model.removeElement(this.currentValue());
            this.model.addElement(path);
        }
    }

    public void doRemovePathEntry() {
        this.model.removeElement(this.currentValue());
    }

    private String currentValue() {
        return (String)this.model.getElementAt(this.list.getSelectedIndex());
    }
}

