/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.progress;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Timer;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Msg;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;

public final class Job {
    private boolean interruptable;
    private boolean finished;
    private int reportedpc;
    private int guessedpc;
    private long sectionend;
    private long sectionstart;
    private int percentend;
    private String jobdesc;
    private Thread work;
    private String statedesc;
    private long start;
    private Map current;
    private Map predicted;
    private int predictedlen;
    private URL predicturl;
    private Timer updater;
    private PropertyChangeSupport listeners;
    private static final Logger log = Logger.getLogger(Job.class);

    protected Job(String description, URL predicturl, Thread work, boolean fakeupdates) {
        this.statedesc = description;
        this.jobdesc = description;
        this.predicturl = predicturl;
        this.work = work;
        this.reportedpc = 0;
        this.finished = false;
        this.interruptable = work != null;
        this.listeners = new PropertyChangeSupport(this);
        this.start = -1L;
        this.predictedlen = -1;
        if (fakeupdates) {
            PredictAction actupdate = new PredictAction();
            this.updater = new Timer(100, actupdate);
            this.updater.start();
        }
        if (predicturl != null) {
            this.loadPredictions();
        }
        this.current = new Properties();
        this.start = System.currentTimeMillis();
        JobManager.fireWorkProgressed(this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(String statedesc) {
        Job job = this;
        synchronized (job) {
            this.statedesc = statedesc;
            if (this.predictedlen != 0) {
                this.guessedpc = this.reportedpc = 100 * this.getAgeFromMap(this.predicted, statedesc) / this.predictedlen;
            } else {
                this.reportedpc = 0;
                this.guessedpc = 0;
            }
            this.predictSection(statedesc);
            this.current.put(statedesc, new Integer((int)(System.currentTimeMillis() - this.start)));
        }
        JobManager.fireWorkProgressed(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(int percent, String statedesc) {
        Job job = this;
        synchronized (job) {
            this.statedesc = statedesc;
            this.reportedpc = percent;
            this.guessedpc = percent;
            this.predictSection(statedesc);
            this.current.put(statedesc, new Integer((int)(System.currentTimeMillis() - this.start)));
        }
        JobManager.fireWorkProgressed(this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Job job = this;
        synchronized (job) {
            this.finished = true;
            this.statedesc = Msg.DONE.toString();
            this.reportedpc = 100;
            this.guessedpc = 100;
            if (this.updater != null) {
                this.updater.stop();
            }
            this.current.put(this.statedesc, new Integer((int)(System.currentTimeMillis() - this.start)));
        }
        JobManager.fireWorkProgressed(this, false);
        if (this.predicturl != null) {
            this.savePredictions();
        }
    }

    public void ignoreTimings() {
        this.predicturl = null;
    }

    public synchronized String getStateDescription() {
        return this.statedesc;
    }

    public void interrupt() {
        if (this.work != null && !this.finished) {
            this.ignoreTimings();
            this.done();
            this.work.interrupt();
        }
    }

    public boolean isInterruptable() {
        return this.interruptable;
    }

    public void setInterruptable(boolean newInterruptable) {
        if (this.work == null || this.finished) {
            return;
        }
        Boolean oldValue = this.interruptable;
        Boolean newValue = newInterruptable;
        this.interruptable = newInterruptable;
        this.listeners.firePropertyChange("interruptable", oldValue, newValue);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized int getPercent() {
        return this.guessedpc;
    }

    public synchronized int getReportedPercent() {
        return this.reportedpc;
    }

    public String getJobDescription() {
        return this.jobdesc;
    }

    private synchronized int getAgeFromMap(Map props, String message) {
        if (props == null) {
            return 0;
        }
        Integer time = (Integer)props.get(message);
        if (time != null) {
            return time;
        }
        return 0;
    }

    protected synchronized void guessProgress() {
        long now = System.currentTimeMillis();
        if (now < this.sectionstart) {
            log.warn("now before started: now=" + new Date(now) + " started=" + new Date(this.sectionstart));
            this.guessedpc = this.reportedpc;
            return;
        }
        if (now == this.sectionstart) {
            this.guessedpc = this.reportedpc;
            return;
        }
        if (now > this.sectionend) {
            this.guessedpc = this.percentend;
            return;
        }
        int sectlen = (int)(this.sectionend - this.sectionstart);
        int sectpc = (int)(100L * (now - this.sectionstart) / (long)sectlen);
        int boost = sectpc * (this.percentend - this.reportedpc) / 100;
        int total = this.reportedpc + boost;
        this.guessedpc = total = total <= 100 ? total : 100;
    }

    private synchronized void predictSection(String message) {
        this.sectionstart = System.currentTimeMillis();
        if (this.predicted == null || this.predictedlen == 0) {
            this.sectionend = 10000L;
            this.percentend = 10;
            return;
        }
        int predsectstart = this.getAgeFromMap(this.predicted, this.statedesc);
        int predsectend = Integer.MAX_VALUE;
        Iterator it = this.predicted.keySet().iterator();
        while (it.hasNext()) {
            String title = (String)it.next();
            int age = (Integer)this.predicted.get(title);
            if (age <= predsectstart || age >= predsectend) continue;
            predsectend = age;
        }
        int predsecttime = predsectend - predsectstart;
        this.sectionend = this.sectionstart + (long)predsecttime;
        int pcstart = 100 * predsectstart / this.predictedlen;
        int pcend = 100 * predsectend / this.predictedlen;
        int pcdiff = pcend - pcstart;
        this.percentend = this.reportedpc + pcdiff;
        log.debug("Predicting " + predsecttime + "ms (" + this.reportedpc + '-' + this.percentend + "%) for section " + message);
    }

    private synchronized void loadPredictions() {
        try {
            InputStream in = this.predicturl.openStream();
            if (in != null) {
                this.predicted = new Properties();
                Properties temp = new Properties();
                temp.load(in);
                Iterator<Object> it = temp.keySet().iterator();
                while (it.hasNext()) {
                    String title = (String)it.next();
                    String timestr = temp.getProperty(title);
                    try {
                        Integer time = new Integer(timestr);
                        this.predicted.put(title, time);
                        int age = time;
                        if (age <= this.predictedlen) continue;
                        this.predictedlen = age;
                    }
                    catch (NumberFormatException ex) {
                        log.error("Time format error", ex);
                    }
                }
            }
        }
        catch (IOException ex) {
            log.debug("Failed to load prediction times - guessing");
        }
    }

    private synchronized void savePredictions() {
        long end = this.start;
        Iterator it = this.current.keySet().iterator();
        while (it.hasNext()) {
            String message = (String)it.next();
            int age = this.getAgeFromMap(this.current, message);
            if ((long)age <= end) continue;
            end = age;
        }
        Properties predictions = new Properties();
        Iterator it2 = this.current.keySet().iterator();
        while (it2.hasNext()) {
            String message = (String)it2.next();
            int age = this.getAgeFromMap(this.current, message);
            predictions.setProperty(message, Integer.toString(age));
        }
        try {
            OutputStream out = NetUtil.getOutputStream(this.predicturl);
            predictions.store(out, "Predicted Startup Times");
        }
        catch (IOException ex) {
            log.error("Failed to save prediction times", ex);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener li) {
        this.listeners.addPropertyChangeListener(li);
    }

    public void removePropertyChangeListener(PropertyChangeListener li) {
        this.listeners.removePropertyChangeListener(li);
    }

    private final class PredictAction
    extends AbstractAction {
        private static final long serialVersionUID = 3256721784160924983L;

        private PredictAction() {
        }

        public void actionPerformed(ActionEvent ev) {
            Job.this.guessProgress();
            JobManager.fireWorkProgressed(Job.this, true);
        }
    }
}

