/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import org.crosswire.bibledesktop.desktop.Msg;
import org.crosswire.bibledesktop.display.URLEvent;
import org.crosswire.bibledesktop.display.URLEventListener;
import org.crosswire.common.progress.swing.JobsProgressBar;

public class StatusBar
extends JComponent
implements MouseListener,
URLEventListener {
    private JobsProgressBar pnl_progr = new JobsProgressBar(true);
    private JLabel lbl_message = new JLabel();
    private JLabel lbl_name = new JLabel();
    private static final long serialVersionUID = 3546920264718955568L;

    public StatusBar() {
        this.initialize();
    }

    private void initialize() {
        this.lbl_message.setText(Msg.STATUS_DEFAULT.toString());
        Font font = this.pnl_progr.getFont();
        this.pnl_progr.setFont(font.deriveFont(6.0f));
        this.lbl_name.setText(' ' + Msg.getVersionedApplicationTitle() + ' ');
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        JSeparator separator = new JSeparator(1);
        JSeparator separator2 = new JSeparator(1);
        this.add((Component)this.lbl_message, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)separator, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnl_progr, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)separator2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lbl_name, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void activateURL(URLEvent ev) {
    }

    public void enterURL(URLEvent ev) {
        String protocol = ev.getProtocol();
        String url = ev.getURL();
        if (protocol.length() == 0) {
            this.lbl_message.setText(url);
        } else {
            this.lbl_message.setText(protocol + "://" + url);
        }
    }

    public void leaveURL(URLEvent ev) {
        this.lbl_message.setText(Msg.STATUS_DEFAULT.toString());
    }

    public void mouseEntered(MouseEvent ev) {
        Object value;
        AbstractButton button;
        Action action;
        if (ev.getSource() instanceof AbstractButton && (action = (button = (AbstractButton)ev.getSource()).getAction()) != null && (value = action.getValue("LongDescription")) != null) {
            this.lbl_message.setText(value.toString());
        }
    }

    public void mouseExited(MouseEvent ev) {
        this.lbl_message.setText(Msg.STATUS_DEFAULT.toString());
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mousePressed(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent ev) {
    }
}

