/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import org.crosswire.common.xml.JDOMSAXEventProvider;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.passage.Key;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BookData {
    private Book book;
    private Key key;
    private Element osis;

    public BookData(Element osis, Book book, Key key) {
        this.osis = osis;
        this.book = book;
        this.key = key;
    }

    public BookData(SAXEventProvider provider, Book book, Key key) throws SAXException {
        SAXHandler handler = new SAXHandler();
        provider.provideSAXEvents((ContentHandler)handler);
        this.osis = handler.getDocument().getRootElement();
        this.book = book;
        this.key = key;
    }

    public Element getOsis() {
        return this.osis;
    }

    public String getVerseText() {
        return OSISUtil.getVerseText(this.getOsis());
    }

    public String getPlainText() {
        return OSISUtil.getPlainText(this.getOsis());
    }

    public void validate() {
    }

    public SAXEventProvider getSAXEventProvider() {
        return new JDOMSAXEventProvider(new Document(this.osis));
    }

    public Book getBook() {
        return this.book;
    }

    public Key getKey() {
        return this.key;
    }
}

