/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.FeatureType;

public final class BookFilters {
    private static BookFilter allBookFilter = new AllBookFilter();
    private static BookFilter biblesBookFilter = new BiblesBookFilter();
    private static BookFilter dictionariesBookFilter = new DictionariesBookFilter();
    private static BookFilter dailyDevotionalsBookFilter = new DailyDevotionalsBookFilter();
    private static BookFilter commentariesBookFilter = new CommentariesBookFilter();
    private static BookFilter greekDefinitionsBookFilter = new GreekDefinitionsBookFilter();
    private static BookFilter greekParseBookFilter = new GreekParseBookFilter();
    private static BookFilter hebrewDefinitionsBookFilter = new HebrewDefinitionsBookFilter();
    private static BookFilter hebrewParseBookFilter = new HebrewParseBookFilter();
    protected static final Logger log = Logger.getLogger((Class)BookFilters.class);
    static /* synthetic */ Class class$org$crosswire$jsword$book$Book;

    private BookFilters() {
    }

    public static BookFilter getAll() {
        return allBookFilter;
    }

    public static BookFilter getBibles() {
        return biblesBookFilter;
    }

    public static BookFilter getDictionaries() {
        return dictionariesBookFilter;
    }

    public static BookFilter getDailyDevotionals() {
        return dailyDevotionalsBookFilter;
    }

    public static BookFilter getCommentaries() {
        return commentariesBookFilter;
    }

    public static BookFilter getGreekDefinitions() {
        return greekDefinitionsBookFilter;
    }

    public static BookFilter getGreekParse() {
        return greekParseBookFilter;
    }

    public static BookFilter getHebrewDefinitions() {
        return hebrewDefinitionsBookFilter;
    }

    public static BookFilter getHebrewParse() {
        return hebrewParseBookFilter;
    }

    public static BookFilter both(final BookFilter b1, final BookFilter b2) {
        return new BookFilter(){

            public boolean test(Book book) {
                return b1.test(book) && b2.test(book);
            }
        };
    }

    public static BookFilter either(final BookFilter b1, final BookFilter b2) {
        return new BookFilter(){

            public boolean test(Book book) {
                return b1.test(book) || b2.test(book);
            }
        };
    }

    public static BookFilter getBooksByDriver(final BookDriver driver) {
        return new BookFilter(){

            public boolean test(Book book) {
                return book.getDriver() == driver;
            }
        };
    }

    public static BookFilter getCustom(String match) {
        return new CustomBookFilter(match);
    }

    private static class CustomBookFilter
    implements BookFilter {
        private Test[] tests;

        public CustomBookFilter(String match) {
            ArrayList<Test> cache = new ArrayList<Test>();
            String[] filters = match.split(";");
            for (int i = 0; i < filters.length; ++i) {
                String[] parts = filters[i].split("=");
                if (parts.length != 2 || parts[0].length() == 0 || parts[1].length() == 0) {
                    throw new IllegalArgumentException("Filter format is 'property=value', given: " + filters[i]);
                }
                Test test = new Test();
                String gettername = "get" + Character.toTitleCase(parts[0].charAt(0)) + parts[0].substring(1);
                try {
                    test.property = (class$org$crosswire$jsword$book$Book == null ? BookFilters.class$("org.crosswire.jsword.book.Book") : class$org$crosswire$jsword$book$Book).getMethod(gettername, null);
                    test.result = parts[1];
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Missing property: " + parts[0] + " in Book");
                }
                cache.add(test);
            }
            this.tests = cache.toArray(new Test[cache.size()]);
        }

        public boolean test(Book book) {
            for (int i = 0; i < this.tests.length; ++i) {
                Test test = this.tests[i];
                try {
                    Object result = test.property.invoke((Object)book, (Object[])null);
                    if (test.result.equals(result.toString())) continue;
                    return false;
                }
                catch (Exception ex) {
                    log.warn("Error while testing property " + test.property.getName() + " on " + book.getName(), (Throwable)ex);
                    return false;
                }
            }
            return true;
        }

        private class Test {
            protected String result;
            protected Method property;

            private Test() {
            }
        }
    }

    private static class HebrewParseBookFilter
    implements BookFilter {
        private HebrewParseBookFilter() {
        }

        public boolean test(Book book) {
            return book.hasFeature(FeatureType.HEBREW_PARSE);
        }
    }

    private static class HebrewDefinitionsBookFilter
    implements BookFilter {
        private HebrewDefinitionsBookFilter() {
        }

        public boolean test(Book book) {
            return book.hasFeature(FeatureType.HEBREW_DEFINITIONS);
        }
    }

    private static class GreekParseBookFilter
    implements BookFilter {
        private GreekParseBookFilter() {
        }

        public boolean test(Book book) {
            return book.hasFeature(FeatureType.GREEK_PARSE);
        }
    }

    private static class GreekDefinitionsBookFilter
    implements BookFilter {
        private GreekDefinitionsBookFilter() {
        }

        public boolean test(Book book) {
            return book.hasFeature(FeatureType.GREEK_DEFINITIONS);
        }
    }

    private static class CommentariesBookFilter
    implements BookFilter {
        private CommentariesBookFilter() {
        }

        public boolean test(Book book) {
            return book.getBookCategory().equals(BookCategory.COMMENTARY);
        }
    }

    private static class DailyDevotionalsBookFilter
    implements BookFilter {
        private DailyDevotionalsBookFilter() {
        }

        public boolean test(Book book) {
            BookCategory category = book.getBookCategory();
            return category.equals(BookCategory.DAILY_DEVOTIONS);
        }
    }

    private static class DictionariesBookFilter
    implements BookFilter {
        private DictionariesBookFilter() {
        }

        public boolean test(Book book) {
            BookCategory category = book.getBookCategory();
            return category.equals(BookCategory.DICTIONARY) || category.equals(BookCategory.GLOSSARY);
        }
    }

    private static class BiblesBookFilter
    implements BookFilter {
        private BiblesBookFilter() {
        }

        public boolean test(Book book) {
            return book.getBookCategory().equals(BookCategory.BIBLE);
        }
    }

    private static class AllBookFilter
    implements BookFilter {
        private AllBookFilter() {
        }

        public boolean test(Book book) {
            return true;
        }
    }
}

