/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.crosswire.common.util.Histogram;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.StringUtil;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.jdom.Content;
import org.jdom.Element;

public class ConfigEntry {
    private static final Logger log = Logger.getLogger((Class)ConfigEntry.class);
    private static Histogram histogram = new Histogram();
    private ConfigEntryType type;
    private String internal;
    private String name;
    private List values;
    private String value;

    public ConfigEntry(String bookName, String aName) {
        this.internal = bookName;
        this.name = aName;
        this.type = ConfigEntryType.fromString(aName);
    }

    public ConfigEntry(String bookName, ConfigEntryType aType, String aValue) {
        this.internal = bookName;
        this.name = aType.getName();
        this.type = aType;
        this.addValue(aValue);
    }

    public String getName() {
        if (this.type != null) {
            return this.type.getName();
        }
        return this.name;
    }

    public ConfigEntryType getType() {
        return this.type;
    }

    public boolean isAllowed(String aValue) {
        if (this.type != null) {
            return this.type.isAllowed(aValue);
        }
        return true;
    }

    public boolean allowsRTF() {
        if (this.type != null) {
            return this.type.allowsRTF();
        }
        return true;
    }

    public boolean allowsContinuation() {
        if (this.type != null) {
            return this.type.allowsContinuation();
        }
        return true;
    }

    public boolean mayRepeat() {
        if (this.type != null) {
            return this.type.mayRepeat();
        }
        return true;
    }

    public boolean reportDetails() {
        if (this.type != null) {
            return this.type.reportDetails();
        }
        return true;
    }

    public boolean isSupported() {
        return this.type != null;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.values != null) {
            return this.values;
        }
        return this.type.getDefault();
    }

    public boolean match(Object search) {
        if (this.value != null) {
            return this.value.equals(search);
        }
        if (this.values != null) {
            return this.values.contains(search);
        }
        Object def = this.type.getDefault();
        return def != null && def.equals(search);
    }

    public void addValue(String val) {
        String aValue = val;
        String confEntryName = this.getName();
        if (this.type != null) {
            aValue = this.type.filter(aValue);
        }
        aValue = this.handleRTF(aValue);
        if (this.mayRepeat()) {
            if (this.values == null) {
                histogram.increment(confEntryName);
                this.values = new ArrayList();
            }
            if (this.reportDetails()) {
                histogram.increment(confEntryName + '.' + aValue);
            }
            if (!this.isAllowed(aValue)) {
                log.info("Ignoring unknown config value for " + confEntryName + " in " + this.internal + ": " + aValue);
                return;
            }
            this.values.add(aValue);
        } else if (this.value != null) {
            log.info("Ignoring unexpected additional entry for " + confEntryName + " in " + this.internal + ": " + aValue);
        } else {
            histogram.increment(confEntryName);
            if (this.type.hasChoices()) {
                histogram.increment(confEntryName + '.' + aValue);
            }
            if (!this.isAllowed(aValue)) {
                log.info("Ignoring unknown config value for " + confEntryName + " in " + this.internal + ": " + aValue);
                return;
            }
            this.value = aValue;
        }
    }

    public Element toOSIS() {
        OSISUtil.OSISFactory factory = OSISUtil.factory();
        Element rowEle = factory.createRow();
        Element nameEle = factory.createCell();
        Element hiEle = factory.createHI();
        hiEle.setAttribute("rend", "bold");
        nameEle.addContent((Content)hiEle);
        Element valueElement = factory.createCell();
        rowEle.addContent((Content)nameEle);
        rowEle.addContent((Content)valueElement);
        hiEle.addContent(this.getName());
        if (this.value != null) {
            String expandedValue = XMLUtil.escape((String)this.value);
            if (this.allowsContinuation() || this.allowsRTF()) {
                valueElement.addContent((Collection)this.processLines(factory, expandedValue));
            } else {
                valueElement.addContent(expandedValue);
            }
        }
        if (this.values != null) {
            Element listEle = factory.createLG();
            valueElement.addContent((Content)listEle);
            Iterator iter = this.values.iterator();
            while (iter.hasNext()) {
                String text = (String)iter.next();
                Element itemEle = factory.createL();
                listEle.addContent((Content)itemEle);
                itemEle.addContent(XMLUtil.escape((String)text));
            }
        }
        return rowEle;
    }

    public static void resetStatistics() {
        histogram.clear();
    }

    public static void dumpStatistics() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ConfigEntry that = (ConfigEntry)obj;
        return that.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    private String handleRTF(String aValue) {
        String copy = aValue;
        copy = copy.replaceAll("\\\\pard ?", "");
        copy = copy.replaceAll("\\\\pa[er] ?", "\n");
        copy = copy.replaceAll("\\\\qc ?", "");
        copy = copy.replaceAll("\\\\[bi]0? ?", "");
        copy = copy.replaceAll("\\\\u-?[0-9]{4,6}+\\?", "");
        copy = copy.replaceAll("[{}]", "");
        if (!this.allowsRTF()) {
            if (!copy.equals(aValue)) {
                log.info("Ignoring unexpected RTF for " + this.getName() + " in " + this.internal + ": " + aValue);
            }
            return aValue;
        }
        return copy;
    }

    private List processLines(OSISUtil.OSISFactory factory, String aValue) {
        ArrayList<Element> list = new ArrayList<Element>();
        String[] lines = StringUtil.splitAll((String)aValue, (char)'\n');
        for (int i = 0; i < lines.length; ++i) {
            Element lineElement = factory.createL();
            lineElement.addContent(lines[i]);
            list.add(lineElement);
        }
        return list;
    }
}

