/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.crosswire.common.util.FileUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.basic.AbstractBookDriver;
import org.crosswire.jsword.book.sword.BookType;
import org.crosswire.jsword.book.sword.ConfigEntry;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.index.IndexStatus;

public class SwordBookDriver
extends AbstractBookDriver {
    public static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static final String DIR_WINDOWS_DEFAULT = "C:\\Program Files\\CrossWire\\The SWORD Project";
    private static final String DIR_SWORD_CONF = ".sword";
    private static final String DIR_UNIX_GLOBAL_CONF = "/etc/sword.conf";
    private static final String PROPERTY_SWORD_HOME = "sword.home";
    private static final String PROPERTY_USER_HOME = "user.home";
    private static final String PREFIX_GLOBALS = "globals.";
    private static final BookDriver INSTANCE = new SwordBookDriver();
    private static File[] dirs = SwordBookDriver.getDefaultPaths();
    private static final Logger log = Logger.getLogger((Class)SwordBookDriver.class);

    public String getDriverName() {
        return "Sword";
    }

    public Book[] getBooks() {
        ConfigEntry.resetStatistics();
        ArrayList<Book> valid = new ArrayList<Book>();
        for (int j = 0; j < dirs.length; ++j) {
            File mods = new File(dirs[j], "mods.d");
            if (mods.isDirectory()) {
                String[] bookdirs = mods.list(new CustomFilenameFilter());
                for (int i = 0; i < bookdirs.length; ++i) {
                    String bookdir = bookdirs[i];
                    try {
                        File configfile = new File(mods, bookdir);
                        String internal = bookdir;
                        if (internal.endsWith(".conf")) {
                            internal = internal.substring(0, internal.length() - 5);
                        }
                        SwordBookMetaData sbmd = new SwordBookMetaData(configfile, internal);
                        sbmd.setDriver(this);
                        Book book = this.createBook(sbmd, dirs[j]);
                        valid.add(book);
                        IndexManager imanager = IndexManagerFactory.getIndexManager();
                        if (imanager.isIndexed(book)) {
                            sbmd.setIndexStatus(IndexStatus.DONE);
                            continue;
                        }
                        sbmd.setIndexStatus(IndexStatus.UNDONE);
                        continue;
                    }
                    catch (Exception ex) {
                        log.warn("Couldn't create SwordBookMetaData", (Throwable)ex);
                    }
                }
                continue;
            }
            log.debug("mods.d directory at " + mods + " does not exist");
        }
        ConfigEntry.dumpStatistics();
        return valid.toArray(new Book[valid.size()]);
    }

    public boolean isDeletable(Book dead) {
        SwordBookMetaData sbmd = (SwordBookMetaData)dead.getBookMetaData();
        File downloadDir = SwordBookDriver.getDownloadDir();
        File confFile = new File(downloadDir, sbmd.getConfPath());
        return confFile.exists();
    }

    public void delete(Book dead) throws BookException {
        SwordBookMetaData sbmd = (SwordBookMetaData)dead.getBookMetaData();
        File downloadDir = SwordBookDriver.getDownloadDir();
        File confFile = new File(downloadDir, sbmd.getConfPath());
        if (!confFile.exists()) {
            throw new BookException((MsgBase)Msg.DELETE_FAILED, new Object[]{confFile});
        }
        File bookDir = new File(downloadDir, sbmd.getBookPath());
        List failures = FileUtil.delete((File)confFile);
        if (failures.size() == 0) {
            failures = FileUtil.delete((File)bookDir);
            Books.installed().removeBook(dead);
        }
        if (failures.size() > 0) {
            throw new BookException((MsgBase)Msg.DELETE_FAILED, new Object[]{failures.get(0)});
        }
    }

    public static BookDriver instance() {
        return INSTANCE;
    }

    public static void registerNewBook(SwordBookMetaData sbmd, File bookpath) throws BookException {
        BookDriver[] drivers = Books.installed().getDriversByClass(SwordBookDriver.class);
        for (int i = 0; i < drivers.length; ++i) {
            SwordBookDriver sdriver = (SwordBookDriver)drivers[i];
            Book book = sdriver.createBook(sbmd, bookpath);
            Books.installed().addBook(book);
        }
    }

    private Book createBook(SwordBookMetaData sbmd, File progdir) throws BookException {
        BookType modtype = sbmd.getBookType();
        if (modtype.getBookCategory() == null) {
            log.warn("No support for book type: DRIVER_RAW_GEN_BOOK");
            throw new BookException(Msg.TYPE_UNSUPPORTED);
        }
        return modtype.createBook(sbmd, progdir);
    }

    public static void setSwordPath(File[] theNewDirs) throws BookException {
        File[] newDirs = theNewDirs;
        if ((newDirs = SwordBookDriver.validateSwordPath(newDirs)) == null) {
            return;
        }
        dirs = newDirs;
        Books.installed().registerDriver(INSTANCE);
    }

    private static File[] validateSwordPath(File[] theFiles) {
        Object[] files = theFiles;
        File downloadDir = dirs[0];
        boolean useDefaultPaths = false;
        if (files == null || files.length == 0) {
            files = SwordBookDriver.getDefaultPaths();
            useDefaultPaths = true;
        }
        if (Arrays.equals(files, dirs)) {
            return EMPTY_FILE_ARRAY;
        }
        if (useDefaultPaths) {
            log.warn("No paths set, using defaults");
        } else if (!((File)files[0]).equals(downloadDir)) {
            int i;
            int pos = -1;
            for (i = 0; i < files.length; ++i) {
                if (!downloadDir.equals(files[i])) continue;
                pos = i;
                break;
            }
            if (pos == -1) {
                File[] temp = new File[files.length + 1];
                temp[0] = downloadDir;
                for (int i2 = 0; i2 < files.length; ++i2) {
                    temp[i2 + 1] = files[i2];
                }
                files = temp;
            } else {
                for (i = pos; i > 0; --i) {
                    files[pos] = files[pos - 1];
                }
                files[0] = downloadDir;
            }
        }
        return files;
    }

    public static File[] getSwordPath() {
        return dirs;
    }

    private static File[] getDefaultPaths() {
        ArrayList<File> reply = new ArrayList<File>();
        reply.add(new File(System.getProperty(PROPERTY_USER_HOME) + File.separator + ".jsword"));
        if (System.getProperty("os.name").startsWith("Windows")) {
            SwordBookDriver.testDefaultPath(reply, DIR_WINDOWS_DEFAULT);
        } else {
            File sysconfig = new File(DIR_UNIX_GLOBAL_CONF);
            if (sysconfig.canRead()) {
                try {
                    Properties prop = new Properties();
                    prop.load(new FileInputStream(sysconfig));
                    String datapath = prop.getProperty(ConfigEntryType.DATA_PATH.toString());
                    SwordBookDriver.testDefaultPath(reply, datapath);
                }
                catch (IOException ex) {
                    log.warn("Failed to read system config file", (Throwable)ex);
                }
            }
        }
        String swordhome = System.getProperty(PROPERTY_SWORD_HOME);
        if (swordhome != null) {
            SwordBookDriver.testDefaultPath(reply, swordhome);
        }
        SwordBookDriver.testDefaultPath(reply, System.getProperty(PROPERTY_USER_HOME) + File.separator + DIR_SWORD_CONF);
        SwordBookDriver.testDefaultPath(reply, new File(".").getAbsolutePath());
        return reply.toArray(new File[reply.size()]);
    }

    private static void testDefaultPath(List reply, String path) {
        File where = new File(path);
        File mods = new File(path, "mods.d");
        if (mods.isDirectory()) {
            reply.add(where);
        }
    }

    public static File getDownloadDir() {
        return dirs[0];
    }

    public static void setDownloadDir(File downloadDir) {
        if (!downloadDir.getPath().equals("")) {
            SwordBookDriver.dirs[0] = downloadDir;
            log.debug("Setting sword download directory to: " + downloadDir);
        }
    }

    private static class CustomFilenameFilter
    implements FilenameFilter {
        private CustomFilenameFilter() {
        }

        public boolean accept(File parent, String name) {
            return !name.startsWith(SwordBookDriver.PREFIX_GLOBALS) && name.endsWith(".conf");
        }
    }
}

