/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.crosswire.bibledesktop.book.BookIcon;
import org.crosswire.bibledesktop.book.install.BookNode;
import org.crosswire.bibledesktop.book.install.Msg;
import org.crosswire.jsword.book.Book;

public class BookTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -942626483282049048L;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        String tooltip = null;
        if (leaf && value instanceof BookNode) {
            Book book = (Book)((BookNode)value).getUserObject();
            this.setLeafIcon(BookIcon.getIcon(book));
            if (book.isQuestionable()) {
                tooltip = Msg.BOOK_QUESTIONABLE.toString();
            }
            if (!book.isSupported()) {
                tooltip = book.isEnciphered() ? Msg.BOOK_LOCKED.toString() : Msg.BOOK_UNSUPPORTED.toString();
            }
        }
        this.setToolTipText(tooltip);
        return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, this.hasFocus);
    }
}

