/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.Msg;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseFactory;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Parent;
import org.jdom.Text;

public final class OSISUtil {
    public static final String HI_BOLD = "bold";
    public static final String HI_ITALIC = "italic";
    public static final String HI_UNDERLINE = "underline";
    public static final String SEG_JUSTIFYRIGHT = "text-align: right;";
    public static final String SEG_CENTER = "text-align: center;";
    public static final String SEG_SMALL = "font-size: small;";
    public static final String SEG_SUPERSCRIPT = "vertical-align: super;";
    public static final String SEG_COLORPREFIX = "color: ";
    public static final String SEG_SIZEPREFIX = "font-size: ";
    public static final String NOTETYPE_STUDY = "x-StudyNote";
    public static final String VARIANT_TYPE = "x-variant";
    public static final String VARIANT_CLASS = "x-class";
    public static final String LEMMA_STRONGS = "strong:";
    public static final String MORPH_ROBINSONS = "robinson:";
    public static final String MORPH_STRONGS = "x-StrongsMorph:T";
    public static final String Q_BLOCK = "blockquote";
    public static final String Q_CITATION = "citation";
    public static final String Q_EMBEDDED = "embedded";
    public static final String LIST_ORDERED = "x-ordered";
    public static final String LIST_UNORDERED = "x-unordered";
    public static final String OSIS_ELEMENT_TITLE = "title";
    public static final String OSIS_ELEMENT_TABLE = "table";
    public static final String OSIS_ELEMENT_SPEECH = "speech";
    public static final String OSIS_ELEMENT_SPEAKER = "speaker";
    public static final String OSIS_ELEMENT_ROW = "row";
    public static final String OSIS_ELEMENT_REFERENCE = "reference";
    public static final String OSIS_ELEMENT_NOTE = "note";
    public static final String OSIS_ELEMENT_NAME = "name";
    public static final String OSIS_ELEMENT_Q = "q";
    public static final String OSIS_ELEMENT_LIST = "list";
    public static final String OSIS_ELEMENT_P = "p";
    public static final String OSIS_ELEMENT_ITEM = "item";
    public static final String OSIS_ELEMENT_FOREIGN = "foreign";
    public static final String OSIS_ELEMENT_W = "w";
    public static final String OSIS_ELEMENT_CHAPTER = "chapter";
    public static final String OSIS_ELEMENT_VERSE = "verse";
    public static final String OSIS_ELEMENT_CELL = "cell";
    public static final String OSIS_ELEMENT_DIV = "div";
    public static final String OSIS_ELEMENT_OSIS = "osis";
    public static final String OSIS_ELEMENT_WORK = "work";
    public static final String OSIS_ELEMENT_HEADER = "header";
    public static final String OSIS_ELEMENT_OSISTEXT = "osisText";
    public static final String OSIS_ELEMENT_SEG = "seg";
    public static final String OSIS_ELEMENT_LG = "lg";
    public static final String OSIS_ELEMENT_L = "l";
    public static final String OSIS_ELEMENT_LB = "lb";
    public static final String OSIS_ELEMENT_HI = "hi";
    public static final String ATTRIBUTE_TEXT_OSISIDWORK = "osisIDWork";
    public static final String ATTRIBUTE_WORK_OSISWORK = "osisWork";
    public static final String OSIS_ATTR_OSISID = "osisID";
    public static final String OSIS_ATTR_SID = "sID";
    public static final String OSIS_ATTR_EID = "eID";
    public static final String ATTRIBUTE_W_LEMMA = "lemma";
    public static final String OSIS_ATTR_TYPE = "type";
    public static final String OSIS_ATTR_SUBTYPE = "subType";
    public static final String OSIS_ATTR_REF = "osisRef";
    public static final String ATTRIBUTE_SPEAKER_WHO = "who";
    public static final String ATTRIBUTE_W_MORPH = "morph";
    public static final String ATTRIBUTE_OSISTEXT_OSISIDWORK = "osisIDWork";
    public static final String OSIS_ATTR_LANG = "xml:lang";
    public static final String ATTRIBUTE_DIV_BOOK = "book";
    private static final String OSISID_PREFIX_BIBLE = "Bible.";
    private static final Set EXTRA_BIBLICAL_ELEMENTS = new HashSet<String>(Arrays.asList("note"));
    private static final Logger log = Logger.getLogger((Class)OSISUtil.class);
    private static OSISFactory factory = new OSISFactory();

    private OSISUtil() {
    }

    public static OSISFactory factory() {
        return factory;
    }

    public static String getVerseText(Element root) {
        StringBuffer buffer = new StringBuffer();
        Element osisText = root.getChild(OSIS_ELEMENT_OSISTEXT);
        Element div = osisText.getChild(OSIS_ELEMENT_DIV);
        Iterator dit = div.getContent().iterator();
        String sid = null;
        Object data = null;
        Element ele = null;
        while (dit.hasNext()) {
            data = dit.next();
            if (data instanceof Element) {
                ele = data;
                if (!ele.getName().equals(OSIS_ELEMENT_VERSE)) continue;
                sid = ele.getAttributeValue(OSIS_ATTR_SID);
                if (sid != null) {
                    OSISUtil.getVerseContent(dit, buffer);
                    continue;
                }
                OSISUtil.getVerseContent(ele.getContent().iterator(), buffer);
                continue;
            }
            if (!(data instanceof Text)) continue;
            buffer.append(((Text)data).getText());
        }
        return buffer.toString().trim();
    }

    public static String getPlainText(Element root) {
        StringBuffer buffer = new StringBuffer();
        Element osisText = root.getChild(OSIS_ELEMENT_OSISTEXT);
        List divs = osisText.getChildren(OSIS_ELEMENT_DIV);
        Iterator divIter = divs.iterator();
        while (divIter.hasNext()) {
            Element div = (Element)divIter.next();
            Iterator contentIter = div.getContent().iterator();
            while (contentIter.hasNext()) {
                Element ele;
                Object data = contentIter.next();
                if (!(data instanceof Element) || !(ele = (Element)data).getName().equals(OSIS_ELEMENT_VERSE)) continue;
                String txt = OSISUtil.getTextContent((Element)data);
                buffer.append(txt);
            }
        }
        return buffer.toString().trim();
    }

    private static void getVerseContent(Iterator iter, StringBuffer buffer) {
        Object data = null;
        Element ele = null;
        String eleName = null;
        while (iter.hasNext()) {
            data = iter.next();
            if (data instanceof Element) {
                ele = data;
                eleName = ele.getName();
                if (eleName.equals(OSIS_ELEMENT_VERSE)) break;
                if (EXTRA_BIBLICAL_ELEMENTS.contains(eleName)) continue;
                OSISUtil.getVerseContent(ele.getContent().iterator(), buffer);
                continue;
            }
            if (!(data instanceof Text)) continue;
            buffer.append(((Text)data).getText());
        }
    }

    private static String getTextContent(Element ele) {
        StringBuffer buffer = new StringBuffer();
        Iterator contentIter = ele.getContent().iterator();
        while (contentIter.hasNext()) {
            Content next = (Content)contentIter.next();
            OSISUtil.recurseElement(next, buffer);
        }
        return buffer.toString();
    }

    public static Collection getDeepContent(Element div, String name) {
        ArrayList reply = new ArrayList();
        OSISUtil.recurseDeepContent(div, name, reply);
        return reply;
    }

    public static Verse getVerse(Element ele) throws BookException {
        if (ele.getName().equals(OSIS_ELEMENT_VERSE)) {
            String osisid = ele.getAttributeValue(OSIS_ATTR_OSISID);
            try {
                return VerseFactory.fromString(osisid);
            }
            catch (NoSuchVerseException ex) {
                throw new BookException(Msg.OSIS_BADID, (Throwable)((Object)ex), new Object[]{osisid});
            }
        }
        Parent parent = ele.getParent();
        if (parent != null && parent instanceof Element) {
            return OSISUtil.getVerse((Element)parent);
        }
        throw new BookException(Msg.MISSING_VERSE);
    }

    public static Element createOsisFramework(BookMetaData bmd) {
        Element osis = OSISUtil.factory().createOsis();
        String osisid = bmd.getInitials();
        Element work = OSISUtil.factory().createWork();
        work.setAttribute(ATTRIBUTE_WORK_OSISWORK, osisid);
        Element header = OSISUtil.factory().createHeader();
        header.addContent((Content)work);
        Element text = OSISUtil.factory().createOsisText();
        text.setAttribute("osisIDWork", OSISID_PREFIX_BIBLE + osisid);
        text.addContent((Content)header);
        osis.addContent((Content)text);
        return osis;
    }

    private static void recurseDeepContent(Element start, String name, List reply) {
        if (start.getName().equals(name)) {
            reply.add(start);
        }
        Iterator contentIter = start.getContent().iterator();
        while (contentIter.hasNext()) {
            Element ele = (Element)contentIter.next();
            OSISUtil.recurseDeepContent(ele, name, reply);
        }
    }

    private static void recurseElement(Object sub, StringBuffer buffer) {
        if (sub instanceof Text) {
            buffer.append(((Text)sub).getText());
        } else if (sub instanceof Element) {
            OSISUtil.recurseChildren((Element)sub, buffer);
        } else {
            log.error("unknown type: " + sub.getClass().getName());
        }
    }

    private static void recurseChildren(Element ele, StringBuffer buffer) {
        try {
            Iterator contentIter = ele.getContent().iterator();
            while (contentIter.hasNext()) {
                Object sub = contentIter.next();
                OSISUtil.recurseElement(sub, buffer);
            }
        }
        catch (Exception ex) {
            log.error("Error interrogating: " + ele.getClass().getName(), (Throwable)ex);
        }
    }

    public static class OSISFactory {
        public Element createSeg() {
            return new Element(OSISUtil.OSIS_ELEMENT_SEG);
        }

        public Element createOsisText() {
            return new Element(OSISUtil.OSIS_ELEMENT_OSISTEXT);
        }

        public Element createHeader() {
            return new Element(OSISUtil.OSIS_ELEMENT_HEADER);
        }

        public Element createWork() {
            return new Element(OSISUtil.OSIS_ELEMENT_WORK);
        }

        public Element createOsis() {
            return new Element(OSISUtil.OSIS_ELEMENT_OSIS);
        }

        public Element createDiv() {
            return new Element(OSISUtil.OSIS_ELEMENT_DIV);
        }

        public Element createCell() {
            return new Element(OSISUtil.OSIS_ELEMENT_CELL);
        }

        public Element createVerse() {
            return new Element(OSISUtil.OSIS_ELEMENT_VERSE);
        }

        public Element createW() {
            return new Element(OSISUtil.OSIS_ELEMENT_W);
        }

        public Element createForeign() {
            return new Element(OSISUtil.OSIS_ELEMENT_FOREIGN);
        }

        public Element createItem() {
            return new Element(OSISUtil.OSIS_ELEMENT_ITEM);
        }

        public Element createP() {
            return new Element(OSISUtil.OSIS_ELEMENT_P);
        }

        public Element createList() {
            return new Element(OSISUtil.OSIS_ELEMENT_LIST);
        }

        public Element createQ() {
            return new Element(OSISUtil.OSIS_ELEMENT_Q);
        }

        public Element createName() {
            return new Element(OSISUtil.OSIS_ELEMENT_NAME);
        }

        public Element createNote() {
            return new Element(OSISUtil.OSIS_ELEMENT_NOTE);
        }

        public Element createReference() {
            return new Element(OSISUtil.OSIS_ELEMENT_REFERENCE);
        }

        public Element createRow() {
            return new Element(OSISUtil.OSIS_ELEMENT_ROW);
        }

        public Element createSpeaker() {
            return new Element(OSISUtil.OSIS_ELEMENT_SPEAKER);
        }

        public Element createSpeech() {
            return new Element(OSISUtil.OSIS_ELEMENT_SPEECH);
        }

        public Element createTable() {
            return new Element(OSISUtil.OSIS_ELEMENT_TABLE);
        }

        public Element createTitle() {
            return new Element(OSISUtil.OSIS_ELEMENT_TITLE);
        }

        public Element createLG() {
            return new Element(OSISUtil.OSIS_ELEMENT_LG);
        }

        public Element createL() {
            return new Element(OSISUtil.OSIS_ELEMENT_L);
        }

        public Element createLB() {
            return new Element(OSISUtil.OSIS_ELEMENT_LB);
        }

        public Element createHI() {
            return new Element(OSISUtil.OSIS_ELEMENT_HI);
        }
    }
}

