/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.display.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.BookDataDisplayFactory;
import org.crosswire.bibledesktop.display.URLEventListener;
import org.crosswire.bibledesktop.display.scrolled.ScrolledBookDataDisplay;
import org.crosswire.bibledesktop.display.tab.Msg;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Passage;

public class TabbedBookDataDisplay
implements BookDataDisplay {
    private static final int TITLE_LENGTH = 25;
    private static int pageSize = 50;
    private transient List hyperlis;
    private Passage key;
    private Passage waiting;
    private Book book;
    private boolean tabs;
    private JTabbedPane tabMain = new JTabbedPane();
    private BookDataDisplay pnlView;
    private Map views = new HashMap();
    private List displays = new ArrayList();
    private Component center;
    private JPanel pnlMore = new JPanel();
    private JPanel pnlMain = new JPanel();

    public TabbedBookDataDisplay() {
        this.pnlView = this.createInnerDisplayPane();
        this.init();
        this.center = this.pnlView.getComponent();
        this.pnlMain.add(this.center, "Center");
    }

    private void init() {
        this.tabMain.setTabPlacement(3);
        this.tabMain.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                TabbedBookDataDisplay.this.tabChanged();
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
    }

    public Component getComponent() {
        return this.pnlMain;
    }

    public void setBookData(Book book, Key newkey) {
        this.book = book;
        this.key = KeyUtil.getPassage((Key)newkey);
        this.tabMain.removeAll();
        this.views.clear();
        this.displays.clear();
        this.displays.add(this.pnlView);
        boolean bl = this.tabs = this.key != null && this.key.countVerses() > pageSize;
        if (this.tabs) {
            Passage first = (Passage)this.key.clone();
            this.waiting = first.trimVerses(pageSize);
            BookDataDisplay pnlNew = this.createInnerDisplayPane();
            pnlNew.setBookData(book, (Key)first);
            Component display = pnlNew.getComponent();
            this.views.put(display, pnlNew);
            this.tabMain.add(TabbedBookDataDisplay.getTabName((Key)first), display);
            this.tabMain.add(Msg.MORE.toString(), this.pnlMore);
            this.setCenterComponent(this.tabMain);
        } else {
            this.pnlView.setBookData(book, (Key)this.key);
            this.setCenterComponent(this.pnlView.getComponent());
        }
        GuiUtil.refresh((Component)this.center);
        GuiUtil.refresh((Component)this.pnlMain);
    }

    public void refresh() {
        Iterator iter = this.displays.iterator();
        while (iter.hasNext()) {
            BookDataDisplay bdd = (BookDataDisplay)iter.next();
            bdd.refresh();
        }
    }

    public Key getKey() {
        return this.key;
    }

    public Book getBook() {
        return this.book;
    }

    public void copy() {
        this.getInnerDisplayPane().copy();
    }

    public synchronized void addURLEventListener(URLEventListener listener) {
        ArrayList<URLEventListener> temp = new ArrayList<URLEventListener>();
        if (this.hyperlis == null) {
            temp.add(listener);
            this.hyperlis = temp;
        } else {
            temp.addAll(this.hyperlis);
            if (!temp.contains(listener)) {
                temp.add(listener);
                this.hyperlis = temp;
            }
        }
        Iterator iter = this.displays.iterator();
        while (iter.hasNext()) {
            BookDataDisplay bdd = (BookDataDisplay)iter.next();
            bdd.addURLEventListener(listener);
        }
    }

    public synchronized void removeURLEventListener(URLEventListener listener) {
        if (this.hyperlis != null && this.hyperlis.contains(listener)) {
            ArrayList temp = new ArrayList();
            temp.addAll(this.hyperlis);
            temp.remove(listener);
            this.hyperlis = temp;
        }
        Iterator iter = this.displays.iterator();
        while (iter.hasNext()) {
            BookDataDisplay bdd = (BookDataDisplay)iter.next();
            bdd.removeURLEventListener(listener);
        }
    }

    private void setCenterComponent(Component comp) {
        if (this.center != comp) {
            this.pnlMain.remove(this.center);
            this.center = comp;
            this.pnlMain.add(this.center, "Center");
        }
    }

    protected void tabChanged() {
        try {
            if (this.tabMain.getSelectedComponent() != this.pnlMore) {
                return;
            }
            this.tabMain.remove(this.pnlMore);
            Passage next = this.waiting;
            this.waiting = next.trimVerses(pageSize);
            BookDataDisplay pnlNew = this.createInnerDisplayPane();
            pnlNew.setBookData(this.book, (Key)next);
            Component display = pnlNew.getComponent();
            this.views.put(display, pnlNew);
            this.tabMain.add(TabbedBookDataDisplay.getTabName((Key)next), display);
            if (this.waiting != null) {
                this.tabMain.add(Msg.MORE.toString(), this.pnlMore);
            }
            this.tabMain.setSelectedComponent(display);
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    public BookDataDisplay getInnerDisplayPane() {
        if (this.tabs) {
            Component o = this.tabMain.getSelectedComponent();
            JScrollPane sp = (JScrollPane)o;
            return (BookDataDisplay)this.views.get(sp);
        }
        return this.pnlView;
    }

    private synchronized BookDataDisplay createInnerDisplayPane() {
        ScrolledBookDataDisplay display = new ScrolledBookDataDisplay(BookDataDisplayFactory.createBookDataDisplay());
        this.displays.add(display);
        if (this.hyperlis != null) {
            Iterator iter = this.hyperlis.iterator();
            while (iter.hasNext()) {
                URLEventListener li = (URLEventListener)iter.next();
                display.addURLEventListener(li);
            }
        }
        return display;
    }

    public static void setPageSize(int pageSize) {
        TabbedBookDataDisplay.pageSize = pageSize;
    }

    public static int getPageSize() {
        return pageSize;
    }

    private static String getTabName(Key key) {
        String tabname = key.getName();
        int len = tabname.length();
        if (len > 25) {
            tabname = tabname.substring(0, 9) + " ... " + tabname.substring(len - 9, len);
        }
        return tabname;
    }
}

