/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import org.crosswire.common.config.swing.AbstractConfigEditor;
import org.crosswire.common.config.swing.ButtonPane;
import org.crosswire.common.config.swing.Msg;
import org.crosswire.common.swing.FormPane;

public class TabbedConfigEditor
extends AbstractConfigEditor {
    private JTabbedPane tab;
    protected static final ImageIcon TAB_ICON = null;
    private static final long serialVersionUID = 3256444715753878326L;

    protected void initializeGUI() {
        ButtonPane bar = new ButtonPane(this);
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add("South", bar);
    }

    protected void updateTree() {
        if (this.tab != null) {
            this.remove(this.tab);
        }
        this.tab = new JTabbedPane();
        Iterator it = this.config.getPaths();
        while (it.hasNext()) {
            String path = (String)it.next();
            JTabbedPane nest = this.tab;
            StringTokenizer st = new StringTokenizer(path, ".");
            while (st.hasMoreTokens()) {
                Component comp;
                String name = st.nextToken();
                int index = nest.indexOfTab(name);
                if (st.hasMoreTokens()) {
                    if (index == -1) {
                        JTabbedPane sub = new JTabbedPane();
                        sub.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                        nest.addTab(name, TAB_ICON, sub);
                        nest = sub;
                        continue;
                    }
                    comp = nest.getComponentAt(index);
                    if (comp instanceof JTabbedPane) {
                        nest = (JTabbedPane)comp;
                        continue;
                    }
                    JTabbedPane sub = new JTabbedPane();
                    sub.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    nest.setComponentAt(index, sub);
                    nest = sub;
                    nest.addTab(Msg.BASIC.toString(), TAB_ICON, comp);
                    continue;
                }
                if (index == -1) {
                    FormPane card = (FormPane)this.decks.get(path);
                    if (card == null) continue;
                    card.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    nest.addTab(name, TAB_ICON, card);
                    continue;
                }
                comp = nest.getComponentAt(index);
                if (!(comp instanceof JTabbedPane)) continue;
                nest = (JTabbedPane)comp;
                FormPane card = (FormPane)this.decks.get(path);
                if (card == null) continue;
                card.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                nest.addTab(Msg.BASIC.toString(), TAB_ICON, card);
            }
        }
        this.add("Center", this.tab);
    }
}

