/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing.desktop;

import java.io.Serializable;
import org.crosswire.common.swing.desktop.AbstractViewLayout;
import org.crosswire.common.swing.desktop.MDIViewLayout;
import org.crosswire.common.swing.desktop.TDIViewLayout;

public abstract class LayoutType
implements Serializable {
    public static final LayoutType TDI;
    public static final LayoutType MDI;
    private String name;
    protected AbstractViewLayout layout;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final LayoutType[] VALUES;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected LayoutType(String name) {
        this.name = name;
    }

    public AbstractViewLayout getLayout() {
        if (this.layout == null) {
            this.layout = this.createLayout();
        }
        return this.layout;
    }

    public abstract AbstractViewLayout createLayout();

    public int toInteger() {
        for (int i = 0; i < VALUES.length; ++i) {
            if (!this.equals(VALUES[i])) continue;
            return i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public static LayoutType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            LayoutType obj = VALUES[i];
            if (!obj.name.equalsIgnoreCase(name)) continue;
            return obj;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static LayoutType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !LayoutType.class.desiredAssertionStatus();
        TDI = new LayoutType("TDI"){
            private static final long serialVersionUID = 3257572784669800241L;

            public AbstractViewLayout createLayout() {
                return new TDIViewLayout();
            }
        };
        MDI = new LayoutType("MDI"){
            private static final long serialVersionUID = 3904681587101874488L;

            public AbstractViewLayout createLayout() {
                return new MDIViewLayout();
            }
        };
        VALUES = new LayoutType[]{TDI, MDI};
    }
}

