/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import org.crosswire.common.xml.XMLFeatureSet;
import org.crosswire.common.xml.XMLHandlerAdapter;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLProcess {
    private static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    private static final String DECLARATION_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/declaration-handler";
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static final String DEFAULT_HANDLER_NAME = "org.crosswire.common.xml.XMLHandlerAdapter";
    private XMLReader parser;
    private XMLHandlerAdapter adapter;
    private XMLFeatureSet features = new XMLFeatureSet();

    public XMLFeatureSet getFeatures() {
        return this.features;
    }

    public static void main(String[] argv) {
        XMLProcess checker = new XMLProcess();
        if (argv.length == 0) {
            checker.usage();
            System.exit(1);
        }
        String arg = null;
        for (int i = 0; i < argv.length; ++i) {
            String option;
            arg = argv[i];
            if (!arg.startsWith("-") || !(option = arg.substring(1)).equals("h")) continue;
            checker.usage();
            System.exit(0);
        }
        checker.initialize(argv);
        checker.parse(arg);
    }

    private void initialize(String[] argv) {
        int i = 0;
        for (i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (!arg.startsWith("-")) continue;
            String option = arg.substring(1);
            if (option.equals("p")) {
                if (++i == argv.length) {
                    System.err.println("error: Missing argument to -p option.");
                }
                String parserName = argv[i];
                this.createParser(parserName);
                continue;
            }
            if (!option.equals("a")) continue;
            if (++i == argv.length) {
                System.err.println("error: Missing argument to -a option.");
            }
            String adapterName = argv[i];
            this.createAdapter(adapterName);
        }
        this.features.setFeatureStates(argv);
    }

    private void bind() {
        this.createParser(DEFAULT_PARSER_NAME);
        this.createAdapter(DEFAULT_HANDLER_NAME);
        this.setHandlers();
        this.features.setFeatures(this.parser);
    }

    private void createParser(String parserName) {
        if (this.parser != null) {
            return;
        }
        try {
            this.parser = XMLReaderFactory.createXMLReader(parserName);
        }
        catch (Exception e) {
            System.err.println("error: Unable to instantiate parser (" + parserName + ")");
        }
    }

    private void createAdapter(String adapterName) {
        if (this.adapter != null) {
            return;
        }
        try {
            this.adapter = (XMLHandlerAdapter)Class.forName(adapterName).newInstance();
        }
        catch (Exception e) {
            System.err.println("error: Unable to instantiate XMLHandlerAdpater (" + adapterName + ")");
        }
    }

    private void setHandlers() {
        this.parser.setDTDHandler(this.adapter);
        this.parser.setErrorHandler(this.adapter);
        this.parser.setContentHandler(this.adapter);
        try {
            this.parser.setProperty(DECLARATION_HANDLER_PROPERTY_ID, this.adapter);
        }
        catch (SAXException e) {
            e.printStackTrace(System.err);
        }
        try {
            this.parser.setProperty(LEXICAL_HANDLER_PROPERTY_ID, this.adapter);
        }
        catch (SAXException e) {
            e.printStackTrace(System.err);
        }
    }

    public void parse(String xmlFile) {
        this.bind();
        try {
            this.parser.parse(xmlFile);
        }
        catch (SAXParseException e) {
        }
        catch (Exception e) {
            Exception nested;
            System.err.println("error: Parse error occurred - " + e.getMessage());
            if (e instanceof SAXException && (nested = ((SAXException)e).getException()) != null) {
                e = nested;
            }
            e.printStackTrace(System.err);
        }
    }

    private void usage() {
        System.err.println("usage: java org.crosswire.common.xml.XMLProcess (options) uri");
        System.err.println();
        System.err.println("options:");
        this.printUsage();
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        this.printDefaults();
    }

    public void printUsage() {
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -a name     Select XMLHandlerAdapter by name.");
        this.features.printUsage();
    }

    public void printDefaults() {
        System.err.println("Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.println("Handler:    org.crosswire.common.xml.XMLHandlerAdapter");
        System.err.println(new XMLFeatureSet().toString());
    }
}

