/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.passage.Key;

public final class SwordUtil {
    private static final Logger log = Logger.getLogger((Class)SwordUtil.class);

    private SwordUtil() {
    }

    protected static byte[] readRAF(RandomAccessFile raf, int offset, int theSize) throws IOException {
        int size = theSize;
        if ((long)(offset + size) > raf.length()) {
            DataPolice.report("Need to reduce size to avoid EOFException. offset=" + offset + " size=" + size + " but raf.length=" + raf.length());
            size = (int)(raf.length() - (long)offset);
        }
        if (size < 1) {
            DataPolice.report("Nothing to read at offset = " + offset + " returning empty because size=" + size);
            return new byte[0];
        }
        raf.seek(offset);
        byte[] read = new byte[size];
        raf.readFully(read);
        return read;
    }

    protected static int decodeLittleEndian32(byte[] data, int offset) {
        int byte1 = data[0 + offset] & 0xFF;
        int byte2 = (data[1 + offset] & 0xFF) << 8;
        int byte3 = (data[2 + offset] & 0xFF) << 16;
        int byte4 = (data[3 + offset] & 0xFF) << 24;
        return byte4 | byte3 | byte2 | byte1;
    }

    protected static int decodeLittleEndian16(byte[] data, int offset) {
        int byte1 = data[0 + offset] & 0xFF;
        int byte2 = (data[1 + offset] & 0xFF) << 8;
        return byte2 | byte1;
    }

    protected static int findByte(byte[] data, byte sought) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != sought) continue;
            return i;
        }
        return -1;
    }

    public static byte[] uncompress(byte[] compressed, int endsize) throws DataFormatException, BookException {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressed);
        byte[] uncompressed = new byte[endsize];
        int realendsize = decompressor.inflate(uncompressed);
        if (!decompressor.finished() || realendsize != endsize) {
            throw new BookException(Msg.GZIP_FORMAT);
        }
        return uncompressed;
    }

    public static String decode(Key key, byte[] data, String charset) {
        if (charset.equals("WINDOWS-1252")) {
            SwordUtil.clean1252(key, data);
        }
        String txt = "";
        try {
            txt = new String(data, charset);
        }
        catch (UnsupportedEncodingException ex) {
            log.error(key + ": Encoding: " + charset + " not supported", (Throwable)ex);
            txt = new String(data);
        }
        return txt;
    }

    public static void clean1252(Key key, byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            int c = data[i] & 0xFF;
            if ((c < 0 || c >= 32 || c == 9 || c == 10 || c == 13) && c != 129 && c != 141 && c != 143 && c != 144 && c != 157) continue;
            data[i] = 32;
            DataPolice.report(key.getName() + " has bad character 0x" + Integer.toString(c, 16) + " at position " + i + " in input.");
        }
    }
}

