/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.crosswire.bibledesktop.book.BookIcon;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.jsword.book.Book;

public class BookListCellRenderer
extends JLabel
implements ListCellRenderer {
    private static Border noFocus = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    public static final String PROTOTYPE_BOOK_NAME = "012345678901234567890123456789";
    private static final long serialVersionUID = 3978138859576308017L;

    public BookListCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocus);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
        if (selected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value == null) {
            this.setText(Msg.NONE.toString());
            this.setToolTipText(null);
            this.setIcon(null);
            this.setEnabled(false);
        }
        if (value instanceof String) {
            String str = (String)value;
            this.setText(str);
            this.setToolTipText(null);
            this.setIcon(null);
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(focus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocus);
        }
        if (value instanceof Book) {
            Book book = (Book)value;
            String displayName = book.toString();
            this.setText(displayName);
            this.setToolTipText(displayName);
            this.setIcon(BookIcon.getIcon(book));
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(focus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocus);
        }
        return this;
    }
}

