/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.crosswire.bibledesktop.passage.Msg;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;

public final class WholeBibleTreeNode
implements TreeNode {
    protected static final int LEVEL_BIBLE = 0;
    protected static final int LEVEL_BOOK = 1;
    protected static final int LEVEL_CHAPTER = 2;
    protected static final int LEVEL_VERSE = 3;
    protected VerseRange range;
    private TreeNode parent;
    private int level;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static WholeBibleTreeNode getRootNode() {
        return new WholeBibleTreeNode(null, VerseRange.getWholeBibleVerseRange(), 0);
    }

    protected static WholeBibleTreeNode getNode(TreeNode parent, int b, int c, int v) {
        try {
            Verse start = null;
            Verse end = null;
            int thislevel = 1;
            if (b == -1) {
                if (!$assertionsDisabled) {
                    throw new AssertionError(b);
                }
            } else if (c == -1) {
                thislevel = 1;
                int ec = BibleInfo.chaptersInBook((int)b);
                int ev = BibleInfo.versesInChapter((int)b, (int)ec);
                start = new Verse(b, 1, 1);
                end = new Verse(b, ec, ev);
            } else if (v == -1) {
                thislevel = 2;
                int ev = BibleInfo.versesInChapter((int)b, (int)c);
                start = new Verse(b, c, 1);
                end = new Verse(b, c, ev);
            } else {
                thislevel = 3;
                end = start = new Verse(b, c, v);
            }
            VerseRange rng = new VerseRange(start, end);
            return new WholeBibleTreeNode(parent, rng, thislevel);
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return null;
        }
    }

    private WholeBibleTreeNode(TreeNode parent, VerseRange range, int level) {
        this.parent = parent != null ? parent : this;
        this.range = range;
        this.level = level;
    }

    public VerseRange getVerseRange() {
        return this.range;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean getAllowsChildren() {
        return this.level != 3;
    }

    public boolean isLeaf() {
        return this.level == 3;
    }

    public String toString() {
        try {
            switch (this.level) {
                case 0: {
                    return Msg.WHOLE.toString();
                }
                case 1: {
                    return BibleInfo.getLongBookName((int)this.range.getStart().getBook());
                }
                case 2: {
                    return Integer.toString(this.range.getStart().getChapter());
                }
                case 3: {
                    return Integer.toString(this.range.getStart().getVerse());
                }
            }
            return Msg.ERROR.toString();
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return "!Error!";
        }
    }

    public TreeNode getChildAt(int i) {
        switch (this.level) {
            case 0: {
                return WholeBibleTreeNode.getNode(this, i + 1, -1, -1);
            }
            case 1: {
                return WholeBibleTreeNode.getNode(this, this.range.getStart().getBook(), i + 1, -1);
            }
            case 2: {
                return WholeBibleTreeNode.getNode(this, this.range.getStart().getBook(), this.range.getStart().getChapter(), i + 1);
            }
            case 3: {
                return null;
            }
        }
        return null;
    }

    public int getChildCount() {
        try {
            switch (this.level) {
                case 0: {
                    return BibleInfo.booksInBible();
                }
                case 1: {
                    return BibleInfo.chaptersInBook((int)this.range.getStart().getBook());
                }
                case 2: {
                    return BibleInfo.versesInChapter((int)this.range.getStart().getBook(), (int)this.range.getStart().getChapter());
                }
                case 3: {
                    return 0;
                }
            }
            return 0;
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return 0;
        }
    }

    public int getIndex(TreeNode node) {
        if (!(node instanceof WholeBibleTreeNode)) {
            return -1;
        }
        WholeBibleTreeNode vnode = (WholeBibleTreeNode)node;
        switch (this.level) {
            case 0: {
                return vnode.getVerseRange().getStart().getBook() - 1;
            }
            case 1: {
                return vnode.getVerseRange().getStart().getChapter() - 1;
            }
            case 2: {
                return vnode.getVerseRange().getStart().getVerse() - 1;
            }
            case 3: {
                return -1;
            }
        }
        return -1;
    }

    public Enumeration children() {
        return new WholeBibleEnumeration();
    }

    static {
        $assertionsDisabled = !WholeBibleTreeNode.class.desiredAssertionStatus();
    }

    public class WholeBibleEnumeration
    implements Enumeration {
        private int count;

        public boolean hasMoreElements() {
            return this.count < WholeBibleTreeNode.this.getChildCount();
        }

        public Object nextElement() {
            ++this.count;
            return WholeBibleTreeNode.this.getChildAt(this.count);
        }
    }
}

