/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.index.AbstractIndex;
import org.crosswire.jsword.index.IndexStatus;
import org.crosswire.jsword.index.lucene.Msg;
import org.crosswire.jsword.index.search.SearchModifier;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseFactory;

public class LuceneIndex
extends AbstractIndex
implements Activatable {
    private static final Object CREATING;
    private boolean active;
    private static final Logger log;
    protected static final String FIELD_NAME = "key";
    protected static final String FIELD_BODY = "content";
    protected static final String FIELD_STRONG = "strong";
    protected Book book;
    private String path;
    protected Searcher searcher;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LuceneIndex(Book book, URL storage) throws BookException {
        this.book = book;
        try {
            this.path = NetUtil.getAsFile((URL)storage).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new BookException((MsgBase)Msg.LUCENE_INIT, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneIndex(Book book, URL storage, boolean create) throws BookException {
        if (!$assertionsDisabled && !create) {
            throw new AssertionError();
        }
        this.book = book;
        File finalPath = null;
        try {
            finalPath = NetUtil.getAsFile((URL)storage);
            this.path = finalPath.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new BookException((MsgBase)Msg.LUCENE_INIT, ex);
        }
        Job job = JobManager.createJob((String)Msg.INDEX_START.toString(), (Thread)Thread.currentThread(), (boolean)false);
        IndexStatus finalStatus = IndexStatus.UNDONE;
        try {
            Object object = CREATING;
            synchronized (object) {
                book.setIndexStatus(IndexStatus.CREATING);
                File tempPath = new File(this.path + '.' + IndexStatus.CREATING.toString());
                IndexWriter writer = new IndexWriter(tempPath.getCanonicalPath(), (Analyzer)new SimpleAnalyzer(), true);
                ArrayList errors = new ArrayList();
                this.generateSearchIndexImpl(job, errors, writer, book.getGlobalKeyList());
                job.setProgress(95, Msg.OPTIMIZING.toString());
                writer.optimize();
                writer.close();
                job.setInterruptable(false);
                if (!job.isFinished()) {
                    tempPath.renameTo(finalPath);
                }
                if (finalPath.exists()) {
                    finalStatus = IndexStatus.DONE;
                }
                if (errors.size() > 0) {
                    StringBuffer buf = new StringBuffer();
                    Iterator iter = errors.iterator();
                    while (iter.hasNext()) {
                        buf.append(iter.next());
                        buf.append('\n');
                    }
                    Reporter.informUser((Object)this, (MsgBase)Msg.BAD_VERSE, (Object)buf);
                }
            }
        }
        catch (Exception ex) {
            job.ignoreTimings();
            throw new BookException((MsgBase)Msg.LUCENE_INIT, ex);
        }
        finally {
            book.setIndexStatus(finalStatus);
            job.done();
        }
    }

    public Key find(String search) throws BookException {
        this.checkActive();
        SearchModifier modifier = this.getSearchModifier();
        Key results = null;
        if (search != null) {
            try {
                SimpleAnalyzer analyzer = new SimpleAnalyzer();
                QueryParser parser = new QueryParser(FIELD_BODY, (Analyzer)analyzer);
                Query query = parser.parse(search);
                Hits hits = this.searcher.search(query);
                if (modifier != null && modifier.isRanked()) {
                    PassageTally tally = new PassageTally();
                    tally.raiseEventSuppresion();
                    tally.raiseNormalizeProtection();
                    results = tally;
                    for (int i = 0; i < hits.length(); ++i) {
                        Verse verse = VerseFactory.fromString(hits.doc(i).get(FIELD_NAME));
                        int score = (int)(hits.score(i) * 100.0f + 1.0f);
                        tally.add(verse, score);
                    }
                    tally.lowerNormalizeProtection();
                    tally.lowerEventSuppresionAndTest();
                } else {
                    results = this.book.createEmptyKeyList();
                    AbstractPassage passage = null;
                    if (results instanceof AbstractPassage) {
                        passage = (AbstractPassage)results;
                        passage.raiseEventSuppresion();
                        passage.raiseNormalizeProtection();
                    }
                    for (int i = 0; i < hits.length(); ++i) {
                        Verse verse = VerseFactory.fromString(hits.doc(i).get(FIELD_NAME));
                        results.addAll(verse);
                    }
                    if (passage != null) {
                        passage.lowerNormalizeProtection();
                        passage.lowerEventSuppresionAndTest();
                    }
                }
            }
            catch (Exception ex) {
                throw new BookException((MsgBase)Msg.SEARCH_FAILED, ex);
            }
            finally {
                Activator.deactivate((Activatable)this);
            }
        }
        if (results == null) {
            results = modifier != null && modifier.isRanked() ? new PassageTally() : this.book.createEmptyKeyList();
        }
        return results;
    }

    public Key getKey(String name) throws NoSuchKeyException {
        return this.book.getKey(name);
    }

    public final void activate(Lock lock) {
        try {
            this.searcher = new IndexSearcher(this.path);
        }
        catch (IOException ex) {
            log.warn("second load failure", (Throwable)ex);
        }
        this.active = true;
    }

    public final void deactivate(Lock lock) {
        try {
            this.searcher.close();
            this.searcher = null;
        }
        catch (IOException ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
        this.active = false;
    }

    protected final void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }

    private void generateSearchIndexImpl(Job job, List errors, IndexWriter writer, Key key) throws BookException, IOException {
        int bookNum = 0;
        int oldBookNum = -1;
        int percent = 0;
        String name = "";
        String text = "";
        BookData data = null;
        Key subkey = null;
        Verse verse = null;
        Document doc = null;
        Iterator it = key.iterator();
        while (it.hasNext()) {
            subkey = (Key)it.next();
            if (subkey.canHaveChildren()) {
                this.generateSearchIndexImpl(job, errors, writer, subkey);
                continue;
            }
            data = null;
            try {
                data = this.book.getData(subkey);
            }
            catch (BookException e) {
                errors.add(subkey);
                continue;
            }
            text = data.getVerseText();
            if (text != null && text.length() > 0) {
                doc = new Document();
                doc.add(new Field(FIELD_NAME, subkey.getOsisRef(), Field.Store.YES, Field.Index.NO));
                doc.add(new Field(FIELD_BODY, (Reader)new StringReader(text)));
                writer.addDocument(doc);
            }
            verse = KeyUtil.getVerse(subkey);
            try {
                percent = 95 * verse.getOrdinal() / BibleInfo.versesInBible();
                bookNum = verse.getBook();
                if (oldBookNum != bookNum) {
                    name = BibleInfo.getBookName(bookNum);
                    oldBookNum = bookNum;
                }
            }
            catch (NoSuchVerseException ex) {
                log.error("Failed to get book name from verse: " + verse, (Throwable)((Object)ex));
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                name = subkey.getName();
            }
            job.setProgress(percent, Msg.INDEXING.toString(name));
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            break;
        }
    }

    static {
        $assertionsDisabled = !LuceneIndex.class.desiredAssertionStatus();
        CREATING = new Object();
        log = Logger.getLogger((Class)LuceneIndex.class);
    }
}

