/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;

public final class Project {
    public static final String DIR_NETCACHE = "netcache";
    public static final String DIR_PROJECT = ".jsword";
    public static final String DIR_PROJECT_ALT = "JSword";
    public static final String WIN32_USER_DATA_AREA = "Application Data";
    public static final String MAC_USER_DATA_AREA = "Library/Application Support";
    private URL userArea;
    private URL home;
    private static final Logger log;
    private static Project instance;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Project instance() {
        return instance;
    }

    private Project() {
        CWClassLoader.setHome((URL)this.getUserProjectDir());
        try {
            URL urlcache = this.getTempScratchSpace(DIR_NETCACHE, true);
            File filecache = new File(urlcache.getFile());
            NetUtil.setURLCacheDir((File)filecache);
        }
        catch (IOException ex) {
            log.warn("Failed to get directory for NetUtil.setURLCacheDir()", (Throwable)ex);
        }
    }

    public URL getUserProjectDir(String unixDefault, String winMacDefault) {
        URL path;
        block7: {
            String projectDir = winMacDefault;
            path = null;
            try {
                if (this.userArea == null) {
                    String user = System.getProperty("user.home");
                    String osName = System.getProperty("os.name");
                    path = new URL("file", null, user);
                    if (osName.startsWith("Mac OS X")) {
                        path = NetUtil.lengthenURL((URL)path, (String)MAC_USER_DATA_AREA);
                    } else if (osName.startsWith("Windows")) {
                        path = NetUtil.lengthenURL((URL)path, (String)WIN32_USER_DATA_AREA);
                    } else {
                        projectDir = unixDefault;
                    }
                    this.userArea = path;
                }
                path = NetUtil.lengthenURL((URL)this.userArea, (String)projectDir);
            }
            catch (MalformedURLException ex) {
                log.fatal("Failed to find user's private data area", (Throwable)ex);
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)ex);
            }
        }
        return path;
    }

    public URL getUserProjectDir() {
        if (this.home == null) {
            URL path = this.getUserProjectDir(DIR_PROJECT, DIR_PROJECT_ALT);
            URL oldPath = this.getDeprecatedUserProjectDir();
            this.home = this.migrateUserProjectDir(oldPath, path);
        }
        return this.home;
    }

    public URL getDeprecatedUserProjectDir() {
        try {
            String user = System.getProperty("user.home");
            URL path = new URL("file", null, user);
            path = NetUtil.lengthenURL((URL)path, (String)DIR_PROJECT);
            return path;
        }
        catch (MalformedURLException ex) {
            log.fatal("Failed to create home directory URL", (Throwable)ex);
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return null;
        }
    }

    private URL migrateUserProjectDir(URL oldPath, URL newPath) {
        if (oldPath.equals(newPath)) {
            return newPath;
        }
        if (NetUtil.isDirectory((URL)oldPath)) {
            File newDir;
            File oldDir = new File(oldPath.getFile());
            if (oldDir.renameTo(newDir = new File(newPath.getFile()))) {
                return newPath;
            }
            return oldPath;
        }
        return newPath;
    }

    public URL getWritablePropertiesURL(String subject) {
        return NetUtil.lengthenURL((URL)this.getUserProjectDir(), (String)(subject + ".properties"));
    }

    public URL getTempScratchSpace(String subject, boolean create) throws IOException {
        URL temp = NetUtil.lengthenURL((URL)this.getUserProjectDir(), (String)subject);
        if (create && !NetUtil.isDirectory((URL)temp)) {
            NetUtil.makeDirectory((URL)temp);
        }
        return temp;
    }

    static {
        $assertionsDisabled = !Project.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)Project.class);
        instance = new Project();
    }
}

