/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.osis;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.crosswire.common.util.Logger;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.passage.Key;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class OSISFilter
implements Filter {
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List toOSIS(Book book, Key key, String plain) {
        DataPolice.setKey(key);
        Element ele = null;
        Throwable ex = null;
        String clean = XMLUtil.cleanAllEntities((String)plain);
        try {
            ele = this.parse(clean);
        }
        catch (JDOMException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        finally {
            DataPolice.setKey(null);
        }
        if (ex != null) {
            DataPolice.report("Parse " + book.getInitials() + "(" + key.getName() + ") failed: " + ex.getMessage() + "\non: " + plain);
            ele = this.cleanTags(book, key, clean);
        }
        if (ele == null) {
            ele = OSISUtil.factory().createP();
        }
        return ele.removeContent();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }

    private Element cleanTags(Book book, Key key, String plain) {
        String shawn = XMLUtil.cleanAllTags((String)plain);
        Throwable ex = null;
        try {
            return this.parse(shawn);
        }
        catch (JDOMException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        log.warn("Could not fix " + book.getInitials() + "(" + key.getName() + ")  by cleaning tags: " + ex.getMessage());
        return null;
    }

    private Element parse(String plain) throws JDOMException, IOException {
        StringReader in = new StringReader("<div>" + plain + "</div>");
        InputSource is = new InputSource(in);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(is);
        Element div = doc.getRootElement();
        return div;
    }

    static {
        $assertionsDisabled = !OSISFilter.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)OSISFilter.class);
    }
}

