/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import org.crosswire.bibledesktop.book.AdvancedSearchPane;
import org.crosswire.bibledesktop.book.BookListCellRenderer;
import org.crosswire.bibledesktop.book.BooksComboBoxModel;
import org.crosswire.bibledesktop.book.DisplaySelectEvent;
import org.crosswire.bibledesktop.book.DisplaySelectListener;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.bibledesktop.book.PassageSelectionPane;
import org.crosswire.bibledesktop.book.install.IndexResolver;
import org.crosswire.bibledesktop.passage.KeyChangeEvent;
import org.crosswire.bibledesktop.passage.KeyChangeListener;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.QuickHelpDialog;
import org.crosswire.common.swing.desktop.event.TitleChangedEvent;
import org.crosswire.common.swing.desktop.event.TitleChangedListener;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.index.IndexStatus;
import org.crosswire.jsword.index.IndexStatusEvent;
import org.crosswire.jsword.index.IndexStatusListener;
import org.crosswire.jsword.index.search.DefaultSearchModifier;
import org.crosswire.jsword.index.search.DefaultSearchRequest;
import org.crosswire.jsword.index.search.SearchModifier;
import org.crosswire.jsword.index.search.SearchRequest;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.RocketPassage;

public class DisplaySelectPane
extends JPanel
implements KeyChangeListener {
    private transient IndexStatusListener isl = new IndexStatusListener(){

        public void statusChanged(IndexStatusEvent ev) {
            DisplaySelectPane.this.enableComponents();
        }
    };
    private static final String VIEW_LABEL = "ViewLabel";
    private static final String PASSAGE_FIELD = "PassageAction";
    private static final String MORE = "More";
    private static final String GO_PASSAGE = "GoPassage";
    private static final String HELP = "HelpAction";
    private static final String SEARCH_LABEL = "SearchLabel";
    private static final String GO_SEARCH = "GoSearch";
    private static final String SEARCH_FIELD = "SearchAction";
    private static final String ADVANCED = "Advanced";
    private static final String BIBLE = "Bible";
    private static final String INDEX = "Index";
    private static final ImageIcon ICON_SELECT;
    private static int base;
    private String title;
    private QuickHelpDialog dlgHelp;
    private transient ActionFactory actions;
    private transient Book selected;
    private BooksComboBoxModel mdlBible;
    private PassageSelectionPane dlgSelect;
    private JTextField txtKey;
    private JTextField txtSearch;
    private JButton btnAdvanced;
    private JButton btnSearch;
    private JButton btnKey;
    private JButton btnKeyGo;
    private AdvancedSearchPane advanced;
    private JButton btnIndex;
    private int mode;
    private static final int CLEAR = 0;
    private static final int PASSAGE = 1;
    private static final int SEARCH = 2;
    private Key key;
    private transient EventListenerList listeners;
    private static int numRankedVerses;
    private static int maxNumRankedVerses;
    private static final long serialVersionUID = 3256446910616057650L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DisplaySelectPane() {
        this.initialize();
    }

    private void initialize() {
        this.listeners = new EventListenerList();
        this.advanced = new AdvancedSearchPane();
        this.title = Msg.UNTITLED.toString(new Integer(base++));
        this.actions = new ActionFactory(DisplaySelectPane.class, (Object)this);
        this.mdlBible = new BooksComboBoxModel(BookFilters.getBibles());
        JComboBox<String> cboBible = new JComboBox<String>(this.mdlBible);
        cboBible.setPrototypeDisplayValue(" ");
        this.selected = this.mdlBible.getSelectedBook();
        if (this.selected != null) {
            this.selected.addIndexStatusListener(this.isl);
            cboBible.setToolTipText(this.selected.toString());
            this.key = this.selected.createEmptyKeyList();
        } else {
            this.key = new RocketPassage();
        }
        cboBible.setRenderer(new BookListCellRenderer());
        cboBible.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 1) {
                    DisplaySelectPane.this.changeVersion();
                    JComboBox combo = (JComboBox)ev.getSource();
                    combo.setToolTipText(combo.getSelectedItem().toString());
                }
            }
        });
        cboBible.addActionListener(new SelectedActionListener());
        JLabel lblBible = this.actions.createJLabel(BIBLE);
        lblBible.setLabelFor(cboBible);
        JLabel lblKey = this.actions.createJLabel(VIEW_LABEL);
        this.txtKey = new JTextField();
        this.txtKey.setAction(this.actions.getAction(PASSAGE_FIELD));
        this.txtKey.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent ev) {
                if (ev.getKeyChar() == '\n' && ev.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                    DisplaySelectPane.this.showSelectDialog();
                }
            }
        });
        this.btnKey = new JButton(this.actions.getAction(MORE));
        this.btnKey.setIcon(ICON_SELECT);
        this.btnKey.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.btnKeyGo = new JButton(this.actions.getAction(GO_PASSAGE));
        this.btnKeyGo.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
        this.txtSearch = new JTextField();
        this.txtSearch.setAction(this.actions.getAction(SEARCH_FIELD));
        JLabel lblSearch = this.actions.createJLabel(SEARCH_LABEL);
        lblSearch.setLabelFor(this.txtSearch);
        this.btnSearch = new JButton(this.actions.getAction(GO_SEARCH));
        this.btnSearch.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
        JButton btnHelp = new JButton(this.actions.getAction(HELP));
        btnHelp.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        btnHelp.setText(null);
        this.dlgHelp = new QuickHelpDialog(GuiUtil.getFrame((Component)this), Msg.HELP_TITLE.toString(), Msg.HELP_TEXT.toString());
        this.btnAdvanced = new JButton(this.actions.getAction(ADVANCED));
        this.btnAdvanced.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.btnIndex = new JButton(this.actions.getAction(INDEX));
        this.btnIndex.setBorder(BorderFactory.createEmptyBorder(3, 15, 3, 15));
        this.setLayout(new GridBagLayout());
        this.add((Component)lblBible, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(cboBible, new GridBagConstraints(2, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)lblKey, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.txtKey, new GridBagConstraints(2, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 1, 2), 0, 0));
        this.add((Component)this.btnKey, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 2, 2), 0, 0));
        this.add((Component)this.btnKeyGo, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)btnHelp, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)lblSearch, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.btnIndex, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 0, 2, 2), 0, 0));
        this.add((Component)this.txtSearch, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 3, 2), 0, 0));
        this.add((Component)this.btnAdvanced, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 2, 2), 0, 0));
        this.add((Component)this.btnSearch, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.enableComponents();
    }

    public Book getBook() {
        return this.selected;
    }

    public void clear() {
        this.setKey((Key)(this.selected == null ? new RocketPassage() : this.selected.createEmptyKeyList()));
        this.setTitle(0);
    }

    public boolean isClear() {
        return this.title.indexOf(Msg.CLEAR.toString()) != -1;
    }

    public void doMore() {
        this.showSelectDialog();
    }

    public void doGoPassage() {
        this.doPassageAction();
    }

    public void doGoSearch() {
        this.doSearchAction();
    }

    public void doPassageAction() {
        this.setKey(this.txtKey.getText());
        if (!this.key.isEmpty()) {
            this.txtSearch.setText("");
            this.setTitle(1);
        }
    }

    public void doSearchAction() {
        if (this.selected == null) {
            this.noBookInstalled();
            return;
        }
        try {
            int total;
            String param = this.txtSearch.getText();
            if (param == null || param.length() == 0) {
                return;
            }
            boolean rank = this.advanced.isRanked();
            DefaultSearchModifier modifier = new DefaultSearchModifier();
            modifier.setRanked(rank);
            Key results = this.selected.find((SearchRequest)new DefaultSearchRequest(param, (SearchModifier)modifier));
            int partial = total = results.getChildCount();
            if (results instanceof PassageTally || rank) {
                PassageTally tally = (PassageTally)results;
                tally.setOrdering(1);
                int rankCount = DisplaySelectPane.getNumRankedVerses();
                if (rankCount > 0 && rankCount < total) {
                    tally.trimRanges(rankCount, RestrictionType.NONE);
                    partial = rankCount;
                }
            }
            if (total == 0) {
                Reporter.informUser((Object)this, (MsgBase)Msg.NO_HITS, (Object[])new Object[]{param});
            } else {
                if (total == partial) {
                    Reporter.informUser((Object)this, (MsgBase)Msg.HITS, (Object[])new Object[]{param, new Integer(total)});
                } else {
                    Reporter.informUser((Object)this, (MsgBase)Msg.PARTIAL_HITS, (Object[])new Object[]{param, Integer.toString(partial), Integer.toString(total)});
                }
                this.setTitle(2);
                this.setKey(results);
            }
        }
        catch (BookException ex) {
            Reporter.informUser((Object)this, (LucidException)ex);
        }
    }

    public void doAdvanced() {
        String reply = this.advanced.showInDialog(this, Msg.ADVANCED_TITLE.toString(), true, this.txtSearch.getText());
        if (reply != null) {
            this.txtSearch.setText(reply);
        }
    }

    public void doRank() {
    }

    public void doHelpAction() {
        this.dlgHelp.setVisible(true);
    }

    public void doIndex() {
        if (this.selected == null) {
            this.noBookInstalled();
            return;
        }
        IndexResolver.scheduleIndex(this.selected, this);
        this.enableComponents();
    }

    private void updateDisplay() {
        if (this.selected == null) {
            this.noBookInstalled();
            return;
        }
        this.fireCommandMade(new DisplaySelectEvent(this, this.key, this.selected));
    }

    public String getTitle() {
        return this.title;
    }

    public void setKey(String newKey) {
        if (this.selected == null) {
            this.noBookInstalled();
            return;
        }
        try {
            this.setKey(this.selected.getKey(newKey));
        }
        catch (NoSuchKeyException e) {
            Reporter.informUser((Object)this, (LucidException)e);
        }
    }

    public void setKey(Key newKey) {
        if (newKey == null || newKey.isEmpty()) {
            if (!this.key.isEmpty()) {
                this.key = this.selected.createEmptyKeyList();
                this.txtKey.setText("");
                this.txtSearch.setText("");
                this.updateDisplay();
                this.setTitle(0);
            }
        } else if (!newKey.equals(this.key)) {
            this.key = newKey;
            String text = this.key.getName();
            this.txtKey.setText(text);
            this.updateDisplay();
            if (this.isClear()) {
                this.setTitle(1);
                this.txtSearch.setText("");
            }
        }
    }

    public static int getNumRankedVerses() {
        return numRankedVerses;
    }

    public static void setNumRankedVerses(int newNumRankedVerses) {
        int count = newNumRankedVerses;
        if (count < 0) {
            count = 0;
        } else if (count > maxNumRankedVerses) {
            count = maxNumRankedVerses;
        }
        numRankedVerses = count;
    }

    public static int getMaxNumRankedVerses() {
        return maxNumRankedVerses;
    }

    public static void setMaxNumRankedVerses(int newMaxNumRankedVerses) {
        int count = newMaxNumRankedVerses;
        if (count < numRankedVerses) {
            count = numRankedVerses;
        }
        maxNumRankedVerses = count;
    }

    public final void changeVersion() {
        Book newSelected = this.mdlBible.getSelectedBook();
        if (this.selected != null && this.selected != newSelected) {
            this.selected.removeIndexStatusListener(this.isl);
            newSelected.addIndexStatusListener(this.isl);
        }
        this.selected = newSelected;
        this.enableComponents();
        if (this.selected == null) {
            this.noBookInstalled();
            return;
        }
        this.fireVersionChanged(new DisplaySelectEvent(this, this.key, this.selected));
    }

    private void setTitle(int newMode) {
        this.mode = newMode;
        switch (this.mode) {
            case 0: {
                this.title = Msg.UNTITLED.toString(new Integer(base++));
                break;
            }
            case 1: {
                this.title = this.key.getName();
                break;
            }
            case 2: {
                this.title = this.txtSearch.getText();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        if (this.title.length() == 0) {
            this.setTitle(0);
        } else {
            this.fireTitleChanged(new TitleChangedEvent((Object)this, this.title));
        }
    }

    private void noBookInstalled() {
        String noBible = Msg.NO_INSTALLED_BIBLE.toString();
        JOptionPane.showMessageDialog(this, noBible, noBible, 2);
    }

    final void enableComponents() {
        boolean readable = this.selected != null;
        boolean searchable = readable && this.selected.getIndexStatus().equals(IndexStatus.DONE);
        boolean indexable = readable && this.selected.getIndexStatus().equals(IndexStatus.UNDONE);
        this.txtSearch.setEnabled(searchable);
        this.txtSearch.setBackground(searchable ? SystemColor.text : SystemColor.control);
        this.txtSearch.setVisible(searchable);
        this.btnAdvanced.setEnabled(searchable);
        this.btnSearch.setEnabled(searchable);
        this.txtKey.setEnabled(readable);
        this.txtKey.setBackground(readable ? SystemColor.text : SystemColor.control);
        this.btnKey.setEnabled(readable);
        this.btnKeyGo.setEnabled(readable);
        this.btnIndex.setVisible(indexable);
        this.btnIndex.setEnabled(indexable);
    }

    final void showSelectDialog() {
        String passg;
        if (this.dlgSelect == null) {
            this.dlgSelect = new PassageSelectionPane();
        }
        if ((passg = this.dlgSelect.showInDialog(this, Msg.SELECT_PASSAGE_TITLE.toString(), true, this.txtKey.getText())) != null) {
            this.txtKey.setText(passg);
            this.doPassageAction();
        }
    }

    public void keyChanged(KeyChangeEvent ev) {
        this.setKey(ev.getKey());
    }

    public synchronized void addTitleChangedListener(TitleChangedListener li) {
        this.listeners.add(TitleChangedListener.class, li);
    }

    public synchronized void removeTitleChangedListener(TitleChangedListener li) {
        this.listeners.remove(TitleChangedListener.class, li);
    }

    protected void fireTitleChanged(TitleChangedEvent ev) {
        Object[] contents = this.listeners.getListenerList();
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != (class$org$crosswire$common$swing$desktop$event$TitleChangedListener == null ? DisplaySelectPane.class$("org.crosswire.common.swing.desktop.event.TitleChangedListener") : class$org$crosswire$common$swing$desktop$event$TitleChangedListener)) continue;
            ((TitleChangedListener)contents[i + 1]).titleChanged(ev);
        }
    }

    public synchronized void addCommandListener(DisplaySelectListener li) {
        this.listeners.add(DisplaySelectListener.class, li);
    }

    public synchronized void removeCommandListener(DisplaySelectListener li) {
        this.listeners.remove(DisplaySelectListener.class, li);
    }

    protected void fireCommandMade(DisplaySelectEvent ev) {
        Object[] contents = this.listeners.getListenerList();
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != (class$org$crosswire$bibledesktop$book$DisplaySelectListener == null ? DisplaySelectPane.class$("org.crosswire.bibledesktop.book.DisplaySelectListener") : class$org$crosswire$bibledesktop$book$DisplaySelectListener)) continue;
            ((DisplaySelectListener)contents[i + 1]).passageSelected(ev);
        }
    }

    protected void fireVersionChanged(DisplaySelectEvent ev) {
        Object[] contents = this.listeners.getListenerList();
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != (class$org$crosswire$bibledesktop$book$DisplaySelectListener == null ? DisplaySelectPane.class$("org.crosswire.bibledesktop.book.DisplaySelectListener") : class$org$crosswire$bibledesktop$book$DisplaySelectListener)) continue;
            ((DisplaySelectListener)contents[i + 1]).bookChosen(ev);
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.selected = null;
        this.listeners = new EventListenerList();
        this.actions = new ActionFactory(DisplaySelectPane.class, (Object)this);
        this.isl = new IndexStatusListener(){

            public void statusChanged(IndexStatusEvent ev) {
                DisplaySelectPane.this.enableComponents();
            }
        };
        is.defaultReadObject();
    }

    static {
        $assertionsDisabled = !DisplaySelectPane.class.desiredAssertionStatus();
        ICON_SELECT = GuiUtil.getIcon((String)"toolbarButtonGraphics/general/Edit16.gif");
        base = 1;
        numRankedVerses = 20;
        maxNumRankedVerses = 200;
    }

    static final class SelectedActionListener
    implements ActionListener {
        SelectedActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox cbo = (JComboBox)e.getSource();
            if (cbo.getSelectedIndex() == -1 && cbo.getItemCount() > 0) {
                cbo.setSelectedIndex(0);
            }
        }
    }
}

