/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;
import org.crosswire.common.util.Msg;

public class EventListenerList
implements Serializable {
    private static final Object[] NULL_ARRAY = new Object[0];
    protected transient Object[] listenerList = NULL_ARRAY;
    private static final long serialVersionUID = 3256999960636436785L;

    public synchronized Object[] getListenerList() {
        int i = this.listenerList.length;
        Object[] tmp = new Object[i];
        System.arraycopy(this.listenerList, 0, tmp, 0, i);
        return tmp;
    }

    public EventListener[] getListeners(Class t) {
        Object[] lList = this.getListenerList();
        int n = this.getListenerCount(lList, t);
        EventListener[] result = (EventListener[])Array.newInstance(t, n);
        int j = 0;
        for (int i = lList.length - 2; i >= 0; i -= 2) {
            if (lList[i] != t) continue;
            result[j++] = (EventListener)lList[i + 1];
        }
        return result;
    }

    public synchronized int getListenerCount() {
        return this.listenerList.length / 2;
    }

    public int getListenerCount(Class t) {
        Object[] lList = this.getListenerList();
        return this.getListenerCount(lList, t);
    }

    private int getListenerCount(Object[] list, Class t) {
        int count = 0;
        for (int i = 0; i < list.length; i += 2) {
            if (t != (Class)list[i]) continue;
            ++count;
        }
        return count;
    }

    public synchronized void add(Class t, EventListener li) {
        if (li == null) {
            return;
        }
        if (!t.isInstance(li)) {
            throw new IllegalArgumentException(Msg.WRONG_TYPE.toString(new Object[]{li, t}));
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new Object[]{t, li};
        } else {
            int i = this.listenerList.length;
            Object[] tmp = new Object[i + 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, i);
            tmp[i] = t;
            tmp[i + 1] = li;
            this.listenerList = tmp;
        }
    }

    public synchronized void remove(Class t, EventListener li) {
        if (li == null) {
            return;
        }
        if (!t.isInstance(li)) {
            throw new IllegalArgumentException(Msg.WRONG_TYPE.toString(new Object[]{li, t}));
        }
        int index = -1;
        for (int i = this.listenerList.length - 2; i >= 0; i -= 2) {
            if (this.listenerList[i] != t || !this.listenerList[i + 1].equals(li)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            Object[] tmp = new Object[this.listenerList.length - 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, index);
            if (index < tmp.length) {
                System.arraycopy(this.listenerList, index + 2, tmp, index, tmp.length - index);
            }
            this.listenerList = tmp.length == 0 ? NULL_ARRAY : tmp;
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Object[] lList = this.getListenerList();
        oos.defaultWriteObject();
        for (int i = 0; i < lList.length; i += 2) {
            Class t = (Class)lList[i];
            EventListener li = (EventListener)lList[i + 1];
            if (li == null || !(li instanceof Serializable)) continue;
            oos.writeObject(t.getName());
            oos.writeObject(li);
        }
        oos.writeObject(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object listenerTypeOrNull;
        this.listenerList = NULL_ARRAY;
        ois.defaultReadObject();
        while ((listenerTypeOrNull = ois.readObject()) != null) {
            EventListener li = (EventListener)ois.readObject();
            this.add(Class.forName((String)listenerTypeOrNull), li);
        }
    }

    public String toString() {
        Object[] lList = this.listenerList;
        StringBuffer s = new StringBuffer("EventListenerList: ");
        s.append(lList.length / 2);
        s.append(" listeners: ");
        for (int i = 0; i <= lList.length - 2; i += 2) {
            s.append(" type ");
            s.append(((Class)lList[i]).getName());
            s.append(" listener ");
            s.append(lList[i + 1]);
        }
        return s.toString();
    }
}

