/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.basic.Msg;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.filter.FilterException;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyFactory;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.jdom.Content;
import org.jdom.Element;

public abstract class AbstractPassageBook
extends AbstractBook {
    private KeyFactory keyf = PassageKeyFactory.instance();
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractPassageBook(BookMetaData bmd) {
        super(bmd);
    }

    public BookData getData(Key key) throws BookException {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        try {
            Element osis = OSISUtil.createOsisFramework(this.getBookMetaData());
            Element text = osis.getChild("osisText");
            Passage ref = KeyUtil.getPassage(key);
            Iterator rit = ref.rangeIterator(RestrictionType.CHAPTER);
            while (rit.hasNext()) {
                VerseRange range = (VerseRange)rit.next();
                Element div = OSISUtil.factory().createDiv();
                text.addContent((Content)div);
                Element title = OSISUtil.factory().createTitle();
                title.addContent(range.getName());
                div.addContent((Content)title);
                Iterator vit = range.iterator();
                while (vit.hasNext()) {
                    Key verse = (Key)vit.next();
                    String txt = this.getText(verse);
                    if (txt.length() <= 0) continue;
                    List osisContent = this.getFilter().toOSIS(this, verse, txt);
                    this.addOSIS(verse, div, osisContent);
                }
            }
            return new BookData(osis, (Book)this, key);
        }
        catch (FilterException ex) {
            throw new BookException((MsgBase)Msg.FILTER_FAIL, (Throwable)((Object)ex));
        }
    }

    public void addOSIS(Key key, Element div, List osisContent) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        div.addContent((Collection)osisContent);
    }

    protected abstract Filter getFilter();

    protected abstract String getText(Key var1) throws BookException;

    public void setDocument(Verse verse, BookData bdata) throws BookException {
        Iterator sit = bdata.getOsis().getChild("osisText").getChildren("div").iterator();
        while (sit.hasNext()) {
            Element div = (Element)sit.next();
            Iterator vit = div.getContent().iterator();
            while (vit.hasNext()) {
                Object data = vit.next();
                if (data instanceof Element) {
                    Element overse = (Element)data;
                    String text = OSISUtil.getPlainText(overse);
                    this.setText(verse, text);
                    continue;
                }
                log.error("Ignoring non OSIS/Verse content of DIV.");
            }
        }
    }

    protected abstract void setText(Verse var1, String var2) throws BookException;

    public final Key createEmptyKeyList() {
        return this.keyf.createEmptyKeyList();
    }

    public final Key getGlobalKeyList() {
        return this.keyf.getGlobalKeyList();
    }

    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    public final Key getKey(String text) throws NoSuchKeyException {
        return this.keyf.getKey(text);
    }

    public String getRawData(Key key) throws BookException {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        StringBuffer buffer = new StringBuffer();
        Passage ref = KeyUtil.getPassage(key);
        Iterator rit = ref.rangeIterator(RestrictionType.CHAPTER);
        while (rit.hasNext()) {
            VerseRange range = (VerseRange)rit.next();
            Iterator vit = range.iterator();
            while (vit.hasNext()) {
                Verse verse = (Verse)vit.next();
                String txt = this.getText(verse);
                if (txt.length() <= 0) continue;
                buffer.append(txt);
                buffer.append('\n');
            }
        }
        return buffer.toString();
    }

    static {
        $assertionsDisabled = !AbstractPassageBook.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)AbstractPassageBook.class);
    }
}

