/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.readings;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.basic.DefaultBookMetaData;
import org.crosswire.jsword.book.readings.Msg;
import org.crosswire.jsword.book.readings.ReadingsBookDriver;
import org.crosswire.jsword.book.readings.ReadingsKey;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyFactory;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.passage.PreferredKey;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.SetKeyList;
import org.crosswire.jsword.passage.VerseRange;
import org.jdom.Content;
import org.jdom.Element;

public class ReadingsBook
extends AbstractBook
implements PreferredKey {
    private Key global;
    private Map hash = new TreeMap();
    private static final Logger log = Logger.getLogger((Class)ReadingsBook.class);

    public ReadingsBook(ReadingsBookDriver driver, String setname, BookCategory type) {
        super(null);
        Locale defaultLocale = Locale.getDefault();
        ResourceBundle prop = ResourceBundle.getBundle(setname, defaultLocale, (ClassLoader)CWClassLoader.instance((Class)ReadingsBookDriver.class));
        String name = Msg.TITLE.toString();
        try {
            name = prop.getString("title");
        }
        catch (MissingResourceException e) {
            log.warn("Missing resource: 'title' while parsing: " + setname);
        }
        DefaultBookMetaData bmd = new DefaultBookMetaData((BookDriver)driver, name, type);
        bmd.setInitials(setname);
        this.setBookMetaData(bmd);
        GregorianCalendar greg = new GregorianCalendar(1972, 0, 1);
        while (greg.get(1) == 1972) {
            String internalKey = ReadingsKey.external2internal(greg);
            String readings = "";
            try {
                readings = prop.getString(internalKey);
            }
            catch (MissingResourceException e) {
                log.warn("Missing resource: " + internalKey + " while parsing: " + setname);
            }
            this.hash.put(new ReadingsKey(greg.getTime()), readings);
            ((Calendar)greg).add(5, 1);
        }
        this.global = new SetKeyList(this.hash.keySet(), this.getName());
    }

    public Key getPreferred() {
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(new Date());
        GregorianCalendar greg = new GregorianCalendar(1972, now.get(2), now.get(5));
        return new ReadingsKey(greg.getTime());
    }

    public BookData getData(Key key) throws BookException {
        if (!(key instanceof ReadingsKey)) {
            throw new BookException((MsgBase)Msg.NOT_FOUND, new Object[]{key.getName()});
        }
        try {
            Element osis = OSISUtil.createOsisFramework(this.getBookMetaData());
            Element text = osis.getChild("osisText");
            Element div = OSISUtil.factory().createDiv();
            Element title = OSISUtil.factory().createTitle();
            title.addContent(Msg.HEADING.toString(key.getName()));
            div.addContent((Content)title);
            text.addContent((Content)div);
            String readings = (String)this.hash.get(key);
            if (readings == null) {
                throw new BookException((MsgBase)Msg.NOT_FOUND, new Object[]{key.getName()});
            }
            try {
                KeyFactory keyf = PassageKeyFactory.instance();
                Passage ref = (Passage)keyf.getKey(readings);
                Element list = OSISUtil.factory().createList();
                div.addContent((Content)list);
                Iterator it = ref.rangeIterator(RestrictionType.NONE);
                while (it.hasNext()) {
                    VerseRange range = (VerseRange)it.next();
                    Element reading = OSISUtil.factory().createReference();
                    reading.setAttribute("osisRef", range.getOsisRef());
                    reading.addContent(range.getName());
                    Element item = OSISUtil.factory().createItem();
                    item.addContent((Content)reading);
                    list.addContent((Content)item);
                }
            }
            catch (NoSuchVerseException ex) {
                div.addContent(Msg.DECODE_ERROR.toString(readings));
            }
            return new BookData(osis, (Book)this, key);
        }
        catch (NoSuchKeyException ex) {
            throw new BookException((MsgBase)Msg.FILTER_FAIL, (Throwable)((Object)ex));
        }
    }

    public String getRawData(Key key) throws BookException {
        return "";
    }

    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    public Key getKey(String name) throws NoSuchKeyException {
        DefaultKeyList reply = new DefaultKeyList();
        reply.addAll(new ReadingsKey(name, name, this.global));
        return reply;
    }

    public Key getGlobalKeyList() {
        return this.global;
    }

    public Key createEmptyKeyList() {
        return new DefaultKeyList();
    }

    public boolean hasFeature(FeatureType feature) {
        return feature == FeatureType.DAILY_DEVOTIONS;
    }
}

