/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.versification.BibleInfo;

public class BitwisePassage
extends AbstractPassage {
    static final long serialVersionUID = -5931560451407396276L;
    protected transient BitSet store = new BitSet(BibleInfo.versesInBible() + 1);
    static final /* synthetic */ boolean $assertionsDisabled;

    protected BitwisePassage() {
    }

    protected BitwisePassage(String refs) throws NoSuchVerseException {
        super(refs);
        this.addVerses(refs);
    }

    public Object clone() {
        BitwisePassage copy = (BitwisePassage)super.clone();
        copy.store = (BitSet)this.store.clone();
        return copy;
    }

    public int countVerses() {
        return this.store.cardinality();
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public Iterator iterator() {
        return new VerseIterator();
    }

    public Iterator rangeIterator(RestrictionType restrict) {
        return new AbstractPassage.VerseRangeIterator(this.iterator(), restrict);
    }

    public boolean contains(Key obj) {
        Iterator iter = obj.iterator();
        while (iter.hasNext()) {
            Verse verse = (Verse)iter.next();
            if (this.store.get(verse.getOrdinal())) continue;
            return false;
        }
        return true;
    }

    public void add(Key obj) {
        this.optimizeWrites();
        Verse firstVerse = null;
        Verse lastVerse = null;
        Iterator iter = obj.iterator();
        while (iter.hasNext()) {
            lastVerse = (Verse)iter.next();
            if (firstVerse == null) {
                firstVerse = lastVerse;
            }
            this.store.set(lastVerse.getOrdinal());
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalAdded(this, firstVerse, lastVerse);
        }
    }

    public void remove(Key obj) {
        this.optimizeWrites();
        Verse firstVerse = null;
        Verse lastVerse = null;
        Iterator iter = obj.iterator();
        while (iter.hasNext()) {
            lastVerse = (Verse)iter.next();
            if (firstVerse == null) {
                firstVerse = lastVerse;
            }
            this.store.clear(lastVerse.getOrdinal());
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalAdded(this, firstVerse, lastVerse);
        }
    }

    public void addAll(Key key) {
        Passage that = KeyUtil.getPassage(key);
        this.optimizeWrites();
        if (that instanceof BitwisePassage) {
            BitwisePassage thatRef = (BitwisePassage)that;
            this.store.or(thatRef.store);
        } else {
            super.addAll(that);
        }
        if (this.suppressEvents == 0 && !that.isEmpty()) {
            this.fireIntervalAdded(this, that.getVerseAt(0), that.getVerseAt(that.countVerses() - 1));
        }
    }

    public void removeAll(Key key) {
        Passage that = KeyUtil.getPassage(key);
        this.optimizeWrites();
        if (that instanceof BitwisePassage) {
            BitwisePassage thatRef = (BitwisePassage)that;
            this.store.andNot(thatRef.store);
        } else {
            super.removeAll(key);
        }
        if (this.suppressEvents == 0 && !that.isEmpty()) {
            this.fireIntervalRemoved(this, that.getVerseAt(0), that.getVerseAt(that.countVerses() - 1));
        }
    }

    public void retainAll(Key key) {
        Passage that = KeyUtil.getPassage(key);
        this.optimizeWrites();
        BitSet thatStore = null;
        if (that instanceof BitwisePassage) {
            thatStore = ((BitwisePassage)that).store;
        } else {
            thatStore = new BitSet(BibleInfo.versesInBible() + 1);
            Iterator it = that.iterator();
            while (it.hasNext()) {
                int ord = ((Verse)it.next()).getOrdinal();
                if (!this.store.get(ord)) continue;
                thatStore.set(ord);
            }
        }
        this.store.and(thatStore);
        this.fireIntervalRemoved(this, null, null);
    }

    public void clear() {
        this.optimizeWrites();
        this.store.clear();
        this.fireIntervalRemoved(this, null, null);
    }

    public void blur(int verses, RestrictionType restrict) {
        if (!$assertionsDisabled && verses <= 0) {
            throw new AssertionError();
        }
        this.optimizeWrites();
        this.raiseNormalizeProtection();
        if (!restrict.equals(RestrictionType.NONE)) {
            super.blur(verses, restrict);
        } else {
            this.optimizeWrites();
            this.raiseEventSuppresion();
            this.raiseNormalizeProtection();
            int versesInBible = BibleInfo.versesInBible();
            BitSet newStore = new BitSet(versesInBible + 1);
            int i = this.store.nextSetBit(0);
            while (i >= 0) {
                int start = Math.max(1, i - verses);
                int end = Math.min(versesInBible, i + verses);
                for (int j = start; j <= end; ++j) {
                    newStore.set(j);
                }
                i = this.store.nextSetBit(i + 1);
            }
            this.store = newStore;
            this.lowerNormalizeProtection();
            if (this.lowerEventSuppresionAndTest()) {
                this.fireIntervalAdded(this, null, null);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeObjectSupport(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.optimizeWrites();
        this.store = new BitSet(BibleInfo.versesInBible() + 1);
        in.defaultReadObject();
        this.readObjectSupport(in);
    }

    static {
        $assertionsDisabled = !BitwisePassage.class.desiredAssertionStatus();
    }

    private final class VerseIterator
    implements Iterator {
        private int next = -1;
        static final /* synthetic */ boolean $assertionsDisabled;

        public VerseIterator() {
            this.calculateNext();
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public Object next() throws NoSuchElementException {
            try {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Verse retcode = new Verse(this.next);
                this.calculateNext();
                return retcode;
            }
            catch (NoSuchVerseException ex) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        private void calculateNext() {
            this.next = BitwisePassage.this.store.nextSetBit(this.next + 1);
        }

        static {
            $assertionsDisabled = !(class$org$crosswire$jsword$passage$BitwisePassage == null ? (class$org$crosswire$jsword$passage$BitwisePassage = BitwisePassage.class$("org.crosswire.jsword.passage.BitwisePassage")) : class$org$crosswire$jsword$passage$BitwisePassage).desiredAssertionStatus();
        }
    }
}

