/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.passage.AbstractKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.RestrictionType;

public class TreeKey
extends AbstractKeyList {
    private Key parent;
    private List children;
    private static final long serialVersionUID = -6560408145705717977L;
    private static final Logger log = Logger.getLogger((Class)TreeKey.class);

    public TreeKey(String name, Key parent) {
        super(name);
        this.parent = parent;
        this.children = new ArrayList();
    }

    public TreeKey(String text) {
        this(text, null);
    }

    public boolean canHaveChildren() {
        return true;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getCardinality() {
        int cardinality = 1;
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            Key child = (Key)iter.next();
            cardinality += child.getCardinality();
        }
        return cardinality;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public boolean contains(Key key) {
        if (this.children.contains(key)) {
            return true;
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            Key child = (Key)iter.next();
            if (!child.contains(key)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return this.children.iterator();
    }

    public void addAll(Key key) {
        this.children.add(key);
    }

    public void removeAll(Key key) {
        this.children.remove(key);
    }

    public void clear() {
        this.children.clear();
    }

    public Key get(int index) {
        return (Key)this.children.get(index);
    }

    public int indexOf(Key that) {
        return this.children.indexOf(that);
    }

    public Key getParent() {
        return this.parent;
    }

    public void blur(int by, RestrictionType restrict) {
        log.warn("attempt to blur a non-blur-able list");
    }

    public Object clone() {
        return super.clone();
    }
}

