/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.IndexInput;

final class SegmentTermPositions
extends SegmentTermDocs
implements TermPositions {
    private IndexInput proxStream;
    private int proxCount;
    private int position;
    private long lazySkipPointer = 0L;
    private int lazySkipDocCount = 0;

    SegmentTermPositions(SegmentReader p) {
        super(p);
        this.proxStream = (IndexInput)this.parent.proxStream.clone();
    }

    final void seek(TermInfo ti) throws IOException {
        super.seek(ti);
        if (ti != null) {
            this.lazySkipPointer = ti.proxPointer;
        }
        this.lazySkipDocCount = 0;
        this.proxCount = 0;
    }

    public final void close() throws IOException {
        super.close();
        this.proxStream.close();
    }

    public final int nextPosition() throws IOException {
        this.lazySkip();
        --this.proxCount;
        return this.position += this.proxStream.readVInt();
    }

    protected final void skippingDoc() throws IOException {
        this.lazySkipDocCount += this.freq;
    }

    public final boolean next() throws IOException {
        this.lazySkipDocCount += this.proxCount;
        if (super.next()) {
            this.proxCount = this.freq;
            this.position = 0;
            return true;
        }
        return false;
    }

    public final int read(int[] docs, int[] freqs) {
        throw new UnsupportedOperationException("TermPositions does not support processing multiple documents in one call. Use TermDocs instead.");
    }

    protected void skipProx(long proxPointer) throws IOException {
        this.lazySkipPointer = proxPointer;
        this.lazySkipDocCount = 0;
        this.proxCount = 0;
    }

    private void skipPositions(int n) throws IOException {
        for (int f = n; f > 0; --f) {
            this.proxStream.readVInt();
        }
    }

    private void lazySkip() throws IOException {
        if (this.lazySkipPointer != 0L) {
            this.proxStream.seek(this.lazySkipPointer);
            this.lazySkipPointer = 0L;
        }
        if (this.lazySkipDocCount != 0) {
            this.skipPositions(this.lazySkipDocCount);
            this.lazySkipDocCount = 0;
        }
    }
}

