/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.examples;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.index.search.DefaultSearchModifier;
import org.crosswire.jsword.index.search.DefaultSearchRequest;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.util.ConverterFactory;
import org.crosswire.jsword.versification.BibleInfo;
import org.xml.sax.SAXException;

public class APIExamples {
    private static final String BIBLE_NAME = "KJV";

    public void readPlainText() throws BookException, NoSuchKeyException {
        Books books = Books.installed();
        Book bible = books.getBook(BIBLE_NAME);
        Key key = bible.getKey("Gen 1 1");
        BookData data = new BookData(bible, key);
        String text = OSISUtil.getCanonicalText(data.getOsisFragment());
        System.out.println("The plain text of Gen 1:1 is " + text);
    }

    public void readStyledText() throws NoSuchKeyException, BookException, TransformerException, SAXException {
        Book bible = Books.installed().getBook(BIBLE_NAME);
        Key key = bible.getKey("Gen 1 1");
        BookData data = new BookData(bible, key);
        SAXEventProvider osissep = data.getSAXEventProvider();
        Converter styler = ConverterFactory.getConverter();
        TransformingSAXEventProvider htmlsep = (TransformingSAXEventProvider)styler.convert(osissep);
        BookMetaData bmd = bible.getBookMetaData();
        boolean direction = bmd.isLeftToRight();
        htmlsep.setParameter("direction", (Object)(direction ? "ltr" : "rtl"));
        String text = XMLUtil.writeToString((SAXEventProvider)htmlsep);
        System.out.println("The html text of Gen 1:1 is " + text);
    }

    public void readDictionary() throws BookException {
        List dicts = Books.installed().getBooks(BookFilters.getDictionaries());
        Book dict = (Book)dicts.get(0);
        Key keys = dict.getGlobalKeyList();
        Key first = (Key)keys.iterator().next();
        System.out.println("The first Key in the default dictionary is " + first);
        BookData data = new BookData(dict, keys);
        System.out.println("And the text against that key is " + OSISUtil.getPlainText(data.getOsisFragment()));
    }

    public void search() throws BookException {
        Book bible = Books.installed().getBook(BIBLE_NAME);
        Key key = bible.find("+moses +aaron");
        System.out.println("The following verses contain both moses and aaron: " + key.getName());
        if (key instanceof Passage) {
            Passage remaining = ((Passage)key).trimVerses(5);
            System.out.println("The first 5 verses containing both moses and aaron: " + key.getName());
            System.out.println("The rest of the verses are: " + remaining.getName());
        }
    }

    void rankedSearch() throws BookException {
        int total;
        Book bible = Books.installed().getBook(BIBLE_NAME);
        boolean rank = true;
        DefaultSearchModifier modifier = new DefaultSearchModifier();
        modifier.setRanked(rank);
        Key results = bible.find(new DefaultSearchRequest("for god so loved the world", modifier));
        int partial = total = results.getCardinality();
        if (results instanceof PassageTally || rank) {
            PassageTally tally = (PassageTally)results;
            tally.setOrdering(1);
            int rankCount = 20;
            if (rankCount > 0 && rankCount < total) {
                tally.trimRanges(rankCount, RestrictionType.NONE);
                partial = rankCount;
            }
        }
        System.out.println("Showing the first " + partial + " of " + total + " verses.");
        System.out.println(results);
    }

    void searchAndShow() throws BookException, SAXException {
        Book bible = Books.installed().getBook(BIBLE_NAME);
        Key key = bible.find("melchesidec~");
        String path = "xsl/cswing/simple.xsl";
        URL xslurl = ResourceUtil.getResource((String)path);
        Iterator rangeIter = ((Passage)key).rangeIterator(RestrictionType.CHAPTER);
        while (rangeIter.hasNext()) {
            Key range = (Key)rangeIter.next();
            BookData data = new BookData(bible, range);
            SAXEventProvider osissep = data.getSAXEventProvider();
            TransformingSAXEventProvider htmlsep = new TransformingSAXEventProvider(NetUtil.toURI((URL)xslurl), osissep);
            String text = XMLUtil.writeToString((SAXEventProvider)htmlsep);
            System.out.println("The html text of " + range.getName() + " is " + text);
        }
    }

    public void export() throws NoSuchKeyException, BookException {
        Book bible = Books.installed().getBook(BIBLE_NAME);
        Key keys = bible.getKey("Gen");
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Verse verse = (Verse)iter.next();
            BookData data = new BookData(bible, verse);
            System.out.println('|' + BibleInfo.getPreferredBookName(verse.getBook()) + '|' + verse.getChapter() + '|' + verse.getVerse() + '|' + OSISUtil.getCanonicalText(data.getOsisFragment()));
        }
    }

    public void pickBible() {
        Book book = Books.installed().getBook(BIBLE_NAME);
        System.out.println(book.getLanguage());
        List books = Books.installed().getBooks();
        book = (Book)books.get(0);
        books = Books.installed().getBooks(BookFilters.getOnlyBibles());
        book = (Book)books.get(0);
        List test = Books.installed().getBooks(new MyBookFilter());
        book = (Book)test.get(0);
        if (book != null) {
            System.out.println(book.getInitials());
        }
        Books.installed().addBooksListener(new MyBooksListener());
    }

    public static void main(String[] args) throws BookException, NoSuchKeyException, TransformerException, SAXException {
        APIExamples examples = new APIExamples();
        examples.readPlainText();
        examples.readStyledText();
        examples.readDictionary();
        examples.search();
        examples.rankedSearch();
        examples.searchAndShow();
        examples.export();
    }

    static class MyBooksListener
    implements BooksListener {
        MyBooksListener() {
        }

        public void bookAdded(BooksEvent ev) {
        }

        public void bookRemoved(BooksEvent ev) {
        }
    }

    static class MyBookFilter
    implements BookFilter {
        MyBookFilter() {
        }

        public boolean test(Book bk) {
            return bk.getName().equals("My Favorite Version");
        }
    }
}

