/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.search;

import java.io.IOException;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.index.Index;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.index.search.Searcher;

public final class SearcherFactory {
    private static final Logger log = Logger.getLogger((Class)SearcherFactory.class);

    private SearcherFactory() {
    }

    public static Searcher createSearcher(Book book) throws InstantiationException {
        try {
            IndexManager imanager = IndexManagerFactory.getIndexManager();
            Index index = imanager.getIndex(book);
            Class impl = ClassUtil.getImplementor((Class)Searcher.class);
            Searcher parser = (Searcher)impl.newInstance();
            parser.init(index);
            return parser;
        }
        catch (IOException e) {
            log.error("createSearcher failed", (Throwable)e);
            throw new InstantiationException();
        }
        catch (BookException e) {
            log.error("createSearcher failed", (Throwable)((Object)e));
            throw new InstantiationException();
        }
        catch (ClassCastException e) {
            log.error("createSearcher failed", (Throwable)e);
            throw new InstantiationException();
        }
        catch (ClassNotFoundException e) {
            log.error("createSearcher failed", (Throwable)e);
            throw new InstantiationException();
        }
        catch (IllegalAccessException e) {
            log.error("createSearcher failed", (Throwable)e);
            throw new InstantiationException();
        }
    }
}

