/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.ConfigException;
import org.crosswire.common.config.Msg;
import org.crosswire.common.config.StartupException;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.jdom.Element;

public abstract class AbstractReflectedChoice
implements Choice {
    private String key;
    private Class clazz;
    private String propertyname;
    private String type;
    private Method getter;
    private Method setter;
    private String helptext;
    private String fullPath;
    private boolean hidden;
    private int priority = 6;
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void init(Element option, ResourceBundle configResources) throws StartupException {
        if (!$assertionsDisabled && configResources == null) {
            throw new AssertionError();
        }
        this.key = option.getAttributeValue("key");
        String hiddenState = option.getAttributeValue("hidden");
        this.hidden = Boolean.valueOf(hiddenState);
        String helpText = configResources.getString(this.key + ".help");
        if (!$assertionsDisabled && helpText == null) {
            throw new AssertionError();
        }
        this.setHelpText(helpText);
        String path = configResources.getString(this.key + ".path");
        if (!$assertionsDisabled && path == null) {
            throw new AssertionError();
        }
        this.setFullPath(path);
        this.type = option.getAttributeValue("type");
        Element introspector = option.getChild("introspect");
        if (introspector == null) {
            throw new StartupException((MsgBase)Msg.CONFIG_MISSINGELE, new Object[]{"introspect"});
        }
        String clazzname = introspector.getAttributeValue("class");
        if (clazzname == null) {
            throw new StartupException((MsgBase)Msg.CONFIG_MISSINGELE, new Object[]{"class"});
        }
        this.propertyname = introspector.getAttributeValue("property");
        if (this.propertyname == null) {
            throw new StartupException((MsgBase)Msg.CONFIG_MISSINGELE, new Object[]{"property"});
        }
        try {
            this.clazz = Class.forName(clazzname);
        }
        catch (ClassNotFoundException ex) {
            throw new StartupException(Msg.CONFIG_NOCLASS, ex, new Object[]{clazzname});
        }
        try {
            this.setter = this.clazz.getMethod("set" + this.propertyname, this.getConversionClass());
        }
        catch (NoSuchMethodException ex) {
            throw new StartupException(Msg.CONFIG_NOSETTER, ex, new Object[]{this.clazz.getName(), this.propertyname, this.getConversionClass().getName()});
        }
        try {
            try {
                this.getter = this.clazz.getMethod("is" + this.propertyname, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.getter = this.clazz.getMethod("get" + this.propertyname, new Class[0]);
            }
        }
        catch (NoSuchMethodException ex) {
            throw new StartupException(Msg.CONFIG_NOGETTER, ex, new Object[]{this.clazz.getName(), this.propertyname});
        }
        if (this.getter.getReturnType() != this.getConversionClass()) {
            log.debug("Not using " + this.propertyname + " from " + this.clazz.getName() + " because the return type of the getter is not " + this.getConversionClass().getName());
            throw new StartupException((MsgBase)Msg.CONFIG_NORETURN, new Object[]{this.getter.getReturnType(), this.getConversionClass()});
        }
        String priorityname = option.getAttributeValue("priority");
        this.priority = priorityname == null ? 6 : Integer.parseInt(priorityname);
    }

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public abstract String convertToString(Object var1);

    public abstract Object convertToObject(String var1);

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String newFullPath) {
        this.fullPath = newFullPath;
    }

    public String getHelpText() {
        return this.helptext;
    }

    public void setHelpText(String helptext) {
        this.helptext = helptext;
    }

    public boolean isSaveable() {
        return true;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean requiresRestart() {
        return false;
    }

    public String getString() {
        try {
            Object retval = this.getter.invoke(null, new Object[0]);
            return this.convertToString(retval);
        }
        catch (IllegalAccessException ex) {
            log.error("Illegal access getting value from " + this.clazz.getName() + "." + this.getter.getName(), ex);
            return "";
        }
        catch (InvocationTargetException ex) {
            log.error("Failed to get value from " + this.clazz.getName() + "." + this.getter.getName(), ex);
            return "";
        }
    }

    public void setString(String value) throws ConfigException {
        Exception ex = null;
        try {
            Object object = this.convertToObject(value);
            this.setter.invoke(null, object);
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        if (ex != null) {
            log.info("Exception while attempting to execute: " + this.setter.toString());
            throw new ConfigException(Msg.CONFIG_SETFAIL, ex, new Object[]{this.setter});
        }
    }

    static {
        $assertionsDisabled = !AbstractReflectedChoice.class.desiredAssertionStatus();
        log = Logger.getLogger(AbstractReflectedChoice.class);
    }
}

