/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.xml.PrettySerializingContentHandler;
import org.crosswire.common.xml.SAXEventProvider;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private static Set goodEntities = new HashSet();
    private static Map badEntities = new HashMap();
    private static final Logger log;
    private static Pattern validCharacterEntityPattern;
    private static Pattern invalidCharacterPattern;

    private XMLUtil() {
    }

    public static Document getDocument(String subject) throws JDOMException, IOException {
        String resource = subject + ".xml";
        InputStream in = ResourceUtil.getResourceAsStream(resource);
        log.debug("Loading " + subject + ".xml from classpath: [OK]");
        SAXBuilder builder = new SAXBuilder(true);
        return builder.build(in);
    }

    public static String writeToString(SAXEventProvider provider) throws SAXException {
        PrettySerializingContentHandler ser = new PrettySerializingContentHandler();
        provider.provideSAXEvents(ser);
        return ((Object)ser).toString();
    }

    public static void debugSAXAttributes(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            log.debug("attr[" + i + "]: " + attrs.getQName(i) + '=' + attrs.getValue(i));
        }
    }

    public static String escape(String s) {
        if (s == null) {
            return s;
        }
        int len = s.length();
        StringBuffer str = new StringBuffer(len);
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block6;
                }
                case '>': {
                    str.append("&gt;");
                    continue block6;
                }
                case '&': {
                    str.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block6;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String cleanAllEntities(String broken) {
        int amp;
        if (broken == null) {
            return null;
        }
        String working = broken;
        int cleanfrom = 0;
        while ((amp = working.indexOf(38, cleanfrom)) != -1) {
            if (validCharacterEntityPattern.matcher(working.substring(amp)).find()) {
                cleanfrom = working.indexOf(59, amp) + 1;
                continue;
            }
            int i = amp + 1;
            while (true) {
                if (i >= working.length()) {
                    return working.substring(0, amp) + "&amp;" + working.substring(amp + 1);
                }
                char c = working.charAt(i);
                if (c == ';') {
                    String entity = working.substring(amp, i + 1);
                    String replace = XMLUtil.handleEntity(entity);
                    working = working.substring(0, amp) + replace + working.substring(i + 1);
                    break;
                }
                if (!Character.isLetterOrDigit(c)) {
                    working = working.substring(0, amp) + "&amp;" + working.substring(amp + 1);
                    amp = i + 4;
                    break;
                }
                ++i;
            }
            cleanfrom = amp + 1;
        }
        return working;
    }

    public static String cleanAllCharacters(String broken) {
        return invalidCharacterPattern.matcher(broken).replaceAll("");
    }

    public static String cleanAllTags(String broken) {
        int lt;
        if (broken == null) {
            return null;
        }
        String working = broken;
        while ((lt = working.indexOf(60)) != -1) {
            int i = lt;
            int startattr = -1;
            while (true) {
                if (++i >= working.length()) {
                    --i;
                    break;
                }
                char c = working.charAt(i);
                if (c == '>') break;
                if (c != ' ') continue;
                if (startattr == -1) {
                    startattr = i;
                    continue;
                }
                String value = working.substring(startattr, i);
                if (value.indexOf(61) == -1) break;
            }
            working = working.substring(0, lt) + working.substring(i + 1);
        }
        return working;
    }

    private static String handleEntity(String entity) {
        if (goodEntities.contains(entity)) {
            return entity;
        }
        String replace = (String)badEntities.get(entity);
        if (replace != null) {
            return replace;
        }
        return "";
    }

    static {
        goodEntities.add("&quot;");
        goodEntities.add("&amp;");
        goodEntities.add("&lt;");
        goodEntities.add("&gt;");
        badEntities.put("&euro;", "\u20ac");
        badEntities.put("&lsquo;", "\u2018");
        badEntities.put("&rsquo;", "\u2019");
        badEntities.put("&nbsp;", "\u00a0");
        badEntities.put("&iexcl;", "\u00a1");
        badEntities.put("&cent;", "\u00a2");
        badEntities.put("&pound;", "\u00a3");
        badEntities.put("&curren;", "\u00a4");
        badEntities.put("&yen;", "\u00a5");
        badEntities.put("&brvbar;", "\u00a6");
        badEntities.put("&sect;", "\u00a7");
        badEntities.put("&uml;", "\u00a8");
        badEntities.put("&copy;", "\u00a9");
        badEntities.put("&ordf;", "\u00aa");
        badEntities.put("&laquo;", "\u00ab");
        badEntities.put("&not;", "\u00ac");
        badEntities.put("&shy;", "\u00ad");
        badEntities.put("&reg;", "\u00ae");
        badEntities.put("&macr;", "\u00af");
        badEntities.put("&deg;", "\u00b0");
        badEntities.put("&plusmn;", "\u00b1");
        badEntities.put("&sup2;", "\u00b2");
        badEntities.put("&sup3;", "\u00b3");
        badEntities.put("&acute;", "\u00b4");
        badEntities.put("&micro;", "\u00b5");
        badEntities.put("&para;", "\u00b6");
        badEntities.put("&middot;", "\u00b7");
        badEntities.put("&cedil;", "\u00b8");
        badEntities.put("&sup1;", "\u00b9");
        badEntities.put("&ordm;", "\u00ba");
        badEntities.put("&raquo;", "\u00bb");
        badEntities.put("&frac14;", "\u00bc");
        badEntities.put("&frac12;", "\u00bd");
        badEntities.put("&frac34;", "\u00be");
        badEntities.put("&iquest;", "\u00bf");
        badEntities.put("&Agrave;", "\u00c0");
        badEntities.put("&Aacute;", "\u00c1");
        badEntities.put("&Acirc;", "\u00c2");
        badEntities.put("&Atilde;", "\u00c3");
        badEntities.put("&Auml;", "\u00c4");
        badEntities.put("&Aring;", "\u00c5");
        badEntities.put("&AElig;", "\u00c6");
        badEntities.put("&Ccedil;", "\u00c7");
        badEntities.put("&Egrave;", "\u00c8");
        badEntities.put("&Eacute;", "\u00c9");
        badEntities.put("&Ecirc;", "\u00ca");
        badEntities.put("&Euml;", "\u00cb");
        badEntities.put("&Igrave;", "\u00cc");
        badEntities.put("&Iacute;", "\u00cd");
        badEntities.put("&Icirc;", "\u00ce");
        badEntities.put("&Iuml;", "\u00cf");
        badEntities.put("&ETH;", "\u00d0");
        badEntities.put("&Ntilde;", "\u00d1");
        badEntities.put("&Ograve;", "\u00d2");
        badEntities.put("&Oacute;", "\u00d3");
        badEntities.put("&Ocirc;", "\u00d4");
        badEntities.put("&Otilde;", "\u00d5");
        badEntities.put("&Ouml;", "\u00d6");
        badEntities.put("&times;", "\u00d7");
        badEntities.put("&Oslash;", "\u00d8");
        badEntities.put("&Ugrave;", "\u00d9");
        badEntities.put("&Uacute;", "\u00da");
        badEntities.put("&Ucirc;", "\u00db");
        badEntities.put("&Uuml;", "\u00dc");
        badEntities.put("&Yacute;", "\u00dd");
        badEntities.put("&THORN;", "\u00de");
        badEntities.put("&szlig;", "\u00df");
        badEntities.put("&agrave;", "\u00e0");
        badEntities.put("&aacute;", "\u00e1");
        badEntities.put("&acirc;", "\u00e2");
        badEntities.put("&atilde;", "\u00e3");
        badEntities.put("&auml;", "\u00e4");
        badEntities.put("&aring;", "\u00e5");
        badEntities.put("&aelig;", "\u00e6");
        badEntities.put("&ccedil;", "\u00e7");
        badEntities.put("&egrave;", "\u00e8");
        badEntities.put("&eacute;", "\u00e9");
        badEntities.put("&ecirc;", "\u00ea");
        badEntities.put("&euml;", "\u00eb");
        badEntities.put("&igrave;", "\u00ec");
        badEntities.put("&iacute;", "\u00ed");
        badEntities.put("&icirc;", "\u00ee");
        badEntities.put("&iuml;", "\u00ef");
        badEntities.put("&eth;", "\u00f0");
        badEntities.put("&ntilde;", "\u00f1");
        badEntities.put("&ograve;", "\u00f2");
        badEntities.put("&oacute;", "\u00f3");
        badEntities.put("&ocirc;", "\u00f4");
        badEntities.put("&otilde;", "\u00f5");
        badEntities.put("&ouml;", "\u00f6");
        badEntities.put("&divide;", "\u00f7");
        badEntities.put("&oslash;", "\u00f8");
        badEntities.put("&ugrave;", "\u00f9");
        badEntities.put("&uacute;", "\u00fa");
        badEntities.put("&ucirc;", "\u00fb");
        badEntities.put("&uuml;", "\u00fc");
        badEntities.put("&yacute;", "\u00fd");
        badEntities.put("&thorn;", "\u00fe");
        badEntities.put("&yuml;", "\u00ff");
        log = Logger.getLogger(XMLUtil.class);
        validCharacterEntityPattern = Pattern.compile("^&#x?\\d{2,4};");
        invalidCharacterPattern = Pattern.compile("[^\t\r\n -\ud7ff\ue000-\ufffd]");
    }
}

