/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import gnu.gpl.License;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLEditorKit;
import org.crosswire.bibledesktop.desktop.Msg;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.AntiAliasedTextPane;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.MapTableModel;
import org.crosswire.common.util.CollectionUtil;

public class AboutPane {
    private static final String SPLASH_FONT = "SanSerif";
    private static final String ABOUT_OK = "AboutOK";
    private static boolean advanced;
    private JDialog dlgMain;
    private JPanel pnlMain;

    public AboutPane() {
        this.init();
    }

    private void init() {
        ImageIcon icon = GuiUtil.getIcon((String)Msg.SPLASH_IMAGE.toString());
        JLabel lblPicture = new JLabel();
        lblPicture.setIcon(icon);
        lblPicture.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        lblPicture.setHorizontalAlignment(0);
        lblPicture.setVerticalAlignment(0);
        JLabel lblInfo = new JLabel();
        lblInfo.setFont(new Font(SPLASH_FONT, 1, 14));
        lblInfo.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        lblInfo.setOpaque(true);
        lblInfo.setHorizontalAlignment(11);
        lblInfo.setText(Msg.getVersionInfo());
        ActionFactory actions = new ActionFactory(AboutPane.class, (Object)this);
        JButton btnOk = new JButton(actions.getAction(ABOUT_OK));
        JPanel pnlButtons = new JPanel();
        pnlButtons.add(btnOk);
        this.pnlMain = new JPanel();
        this.pnlMain.setLayout(new BorderLayout(5, 5));
        this.pnlMain.add((Component)pnlButtons, "South");
        this.pnlMain.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel pnlSplash = new JPanel();
        pnlSplash.setLayout(new BorderLayout(5, 0));
        pnlSplash.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlSplash.add((Component)lblPicture, "Center");
        pnlSplash.add((Component)lblInfo, "South");
        JTabbedPane tabMain = new JTabbedPane();
        this.pnlMain.add((Component)tabMain, "Center");
        String appName = Msg.getApplicationTitle();
        tabMain.add((Component)pnlSplash, appName);
        License license = new License(appName);
        AntiAliasedTextPane warranty = new AntiAliasedTextPane();
        warranty.setEditable(false);
        warranty.setEditorKit(new HTMLEditorKit());
        warranty.setText(license.getWarranty());
        warranty.setCaretPosition(0);
        CWScrollPane warrantyScr = new CWScrollPane((Component)warranty);
        warrantyScr.setPreferredSize(new Dimension(500, 300));
        JPanel warrantyPnl = new JPanel(new BorderLayout());
        warrantyPnl.add((Component)warrantyScr, "Center");
        warrantyPnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tabMain.add((Component)warrantyPnl, Msg.WARRANTY_TAB_TITLE.toString());
        AntiAliasedTextPane details = new AntiAliasedTextPane();
        details.setEditable(false);
        details.setEditorKit(new HTMLEditorKit());
        details.setText(license.getDetails());
        details.setCaretPosition(0);
        CWScrollPane detailScr = new CWScrollPane((Component)details);
        detailScr.setPreferredSize(new Dimension(500, 300));
        JPanel detailsPnl = new JPanel(new BorderLayout());
        detailsPnl.add((Component)detailScr, "Center");
        detailsPnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tabMain.add((Component)detailsPnl, Msg.DETAILS_TAB_TITLE.toString());
        if (advanced) {
            JTable tblProps = new JTable();
            MapTableModel mdlProps = new MapTableModel(CollectionUtil.properties2Map((Properties)System.getProperties()));
            tblProps.setModel((TableModel)mdlProps);
            CWScrollPane scrProps = new CWScrollPane((Component)tblProps);
            scrProps.setPreferredSize(new Dimension(500, 300));
            JPanel pnlProps = new JPanel();
            pnlProps.setLayout(new BorderLayout());
            pnlProps.add((Component)scrProps, "Center");
            pnlProps.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            tabMain.add((Component)pnlProps, Msg.SYSTEM_PROPS_TAB_TITLE.toString());
        }
        GuiUtil.applyDefaultOrientation((Component)this.pnlMain);
    }

    public void doAboutOK() {
        if (this.dlgMain != null) {
            this.dlgMain.dispose();
            this.dlgMain = null;
        }
    }

    public void showInDialog(Component parent) {
        this.dlgMain = new JDialog(JOptionPane.getFrameForComponent(parent));
        this.dlgMain.getContentPane().add(this.pnlMain);
        this.dlgMain.setTitle(Msg.getAboutInfo());
        this.dlgMain.setModal(true);
        this.dlgMain.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent ev) {
                AboutPane.this.doAboutOK();
            }
        });
        GuiUtil.applyDefaultOrientation((Component)this.dlgMain);
        this.dlgMain.pack();
        this.dlgMain.setLocationRelativeTo(parent);
        this.dlgMain.setVisible(true);
    }

    public static synchronized boolean isAdvanced() {
        return advanced;
    }

    public static synchronized void setAdvanced(boolean advanced) {
        AboutPane.advanced = advanced;
    }
}

