/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import org.crosswire.common.config.ChoiceFactory;
import org.crosswire.common.util.Languages;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.util.Project;

public class Translations {
    private static final String TRANSLATION_KEY = "translation-codes";
    public static final String DEFAULT_TRANSLATION = "en";
    private String translation = "en";
    private String[] translations = new String[]{"en", "de", "fa"};
    private static Translations instance = new Translations();
    private static final Logger log = Logger.getLogger((Class)Translations.class);

    private Translations() {
        try {
            URI inputURI = Project.instance().getWritablePropertiesURI(this.getClass().getName());
            Properties props = NetUtil.loadProperties((URI)inputURI);
            this.translation = props.getProperty(TRANSLATION_KEY, DEFAULT_TRANSLATION);
        }
        catch (IOException e) {
            this.translation = DEFAULT_TRANSLATION;
        }
    }

    public static Translations instance() {
        return instance;
    }

    public String[] getSupported() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.translations.length; ++i) {
            names.add(Languages.getLanguage((String)this.translations[i]));
        }
        return names.toArray(new String[names.size()]);
    }

    public Locale getCurrentLocale() {
        return new Locale(this.translation);
    }

    public String getCurrent() {
        return Languages.getLanguage((String)this.translation);
    }

    public void setCurrent(String newTranslation) {
        String lang = DEFAULT_TRANSLATION;
        String currentLang = "";
        for (int i = 0; i < this.translations.length; ++i) {
            currentLang = Languages.getLanguage((String)this.translations[i]);
            if (!currentLang.equals(newTranslation)) continue;
            lang = this.translations[i];
        }
        try {
            this.translation = lang;
            Properties props = new Properties();
            props.put(TRANSLATION_KEY, this.translation);
            URI outputURI = Project.instance().getWritablePropertiesURI(this.getClass().getName());
            NetUtil.storeProperties((Properties)props, (URI)outputURI, (String)"BibleDesktop UI Translation");
        }
        catch (IOException ex) {
            log.error("Failed to save BibleDesktop UI Translation", (Throwable)ex);
        }
    }

    public void setLocale() {
        if (!this.translation.equals(DEFAULT_TRANSLATION)) {
            Locale.setDefault(this.getCurrentLocale());
        }
    }

    public void register() {
        ChoiceFactory.getDataMap().put(TRANSLATION_KEY, Translations.getSupportedTranslations());
    }

    public static String getCurrentTranslation() {
        return Translations.instance().getCurrent();
    }

    public static void setCurrentTranslation(String newTranslation) {
        Translations.instance().setCurrent(newTranslation);
    }

    public static String[] getSupportedTranslations() {
        return Translations.instance().getSupported();
    }
}

