/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.progress.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.progress.WorkEvent;
import org.crosswire.common.progress.WorkListener;
import org.crosswire.common.progress.swing.Msg;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.Logger;

public class JobsViewPane
extends JPanel
implements WorkListener {
    protected Map jobs;
    private List positions;
    private JPanel jobsPanel;
    private JLabel noJobLabel;
    private static final Logger log = Logger.getLogger((Class)JobsViewPane.class);
    private static final long serialVersionUID = 3546366136561315891L;

    public JobsViewPane() {
        this.init();
        JobManager.addWorkListener((WorkListener)this);
        Set current = JobManager.getJobs();
        Iterator it = current.iterator();
        while (it.hasNext()) {
            Progress job = (Progress)it.next();
            this.addJob(job);
        }
        GuiUtil.applyDefaultOrientation(this);
    }

    private void init() {
        this.noJobLabel = new JLabel(Msg.NO_JOBS.toString());
        this.jobs = new HashMap();
        this.positions = new ArrayList();
        this.jobsPanel = new JPanel(new GridBagLayout());
        this.jobsPanel.setBorder(null);
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.jobsPanel, "North");
        CWScrollPane scrollPane = new CWScrollPane(pnl);
        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.setPreferredSize(new Dimension(500, 300));
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.add((Component)new JPanel(), "South");
        this.add((Component)new JPanel(), "After");
        this.add((Component)new JPanel(), "Before");
        this.add((Component)new JPanel(), "North");
    }

    public synchronized void workProgressed(WorkEvent ev) {
        SwingUtilities.invokeLater(new JobRunner(this, ev));
    }

    public void workStateChanged(WorkEvent ev) {
    }

    final void addJob(Progress job) {
        int i = this.findEmptyPosition();
        log.debug("adding job to panel at " + i + ": " + job.getJobName());
        JProgressBar progress = new JProgressBar();
        progress.setStringPainted(true);
        progress.setString("0%");
        progress.setToolTipText(job.getJobName());
        progress.setValue(0);
        JLabel label = new JLabel(job.getJobName() + ":");
        JButton cancel = new JButton(Msg.CANCEL.toString());
        if (!job.isCancelable()) {
            cancel.setEnabled(false);
        }
        cancel.addActionListener(new CancelListener(job));
        this.jobsPanel.add((Component)label, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 22, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jobsPanel.add((Component)progress, new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jobsPanel.add((Component)cancel, new GridBagConstraints(2, i, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        GuiUtil.refresh(this);
        JobData jobdata = new JobData(job, i, label, progress, cancel);
        this.jobs.put(job, jobdata);
        if (i >= this.positions.size()) {
            this.positions.add(jobdata);
        } else {
            this.positions.set(i, jobdata);
        }
    }

    protected void updateJob(Progress job) {
        JobData jobdata = (JobData)this.jobs.get(job);
        int percent = job.getWork();
        jobdata.getProgress().setString(percent + "%");
        jobdata.getProgress().setToolTipText(job.getSectionName());
        jobdata.getProgress().setValue(percent);
    }

    protected void removeJob(Progress job) {
        JobData jobdata = (JobData)this.jobs.get(job);
        log.debug("removing job from panel at " + jobdata.getIndex() + ": " + job.getJobName());
        this.positions.set(jobdata.getIndex(), null);
        this.jobs.remove(job);
        this.jobsPanel.remove(jobdata.getLabel());
        this.jobsPanel.remove(jobdata.getProgress());
        this.jobsPanel.remove(jobdata.getCancel());
        GuiUtil.refresh(this);
        jobdata.invalidate();
    }

    protected void addEmptyLabel() {
        this.jobsPanel.add((Component)this.noJobLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 22, 1, new Insets(5, 5, 5, 5), 0, 0));
        GuiUtil.refresh(this);
    }

    protected void removeEmptyLabel() {
        this.jobsPanel.remove(this.noJobLabel);
        GuiUtil.refresh(this);
    }

    private int findEmptyPosition() {
        int i;
        for (i = 0; i < this.positions.size() && this.positions.get(i) != null; ++i) {
        }
        return i;
    }

    private static class JobData {
        private Progress job;
        private JLabel label;
        private JProgressBar progress;
        private JButton cancel;
        private int index = -1;

        public JobData(Progress job, int index, JLabel label, JProgressBar progress, JButton cancel) {
            this.job = job;
            this.index = index;
            this.label = label;
            this.progress = progress;
            this.cancel = cancel;
        }

        void invalidate() {
            this.job = null;
            this.label = null;
            this.progress = null;
            this.cancel = null;
            this.index = -1;
        }

        Progress getJob() {
            return this.job;
        }

        JLabel getLabel() {
            return this.label;
        }

        JProgressBar getProgress() {
            return this.progress;
        }

        JButton getCancel() {
            return this.cancel;
        }

        int getIndex() {
            return this.index;
        }
    }

    private static final class CancelListener
    implements ActionListener {
        private Progress job;

        public CancelListener(Progress theJob) {
            this.job = theJob;
        }

        public void actionPerformed(ActionEvent ev) {
            this.job.cancel();
        }
    }

    private static final class JobRunner
    implements Runnable {
        private JobsViewPane pane;
        private WorkEvent event;

        public JobRunner(JobsViewPane jvp, WorkEvent ev) {
            this.pane = jvp;
            this.event = ev;
        }

        public void run() {
            Progress job = this.event.getJob();
            if (!this.pane.jobs.containsKey(job)) {
                if (this.pane.jobs.isEmpty()) {
                    this.pane.removeEmptyLabel();
                }
                this.pane.addJob(job);
            }
            this.pane.updateJob(job);
            if (job.isFinished()) {
                this.pane.removeJob(job);
                if (this.pane.jobs.isEmpty()) {
                    this.pane.addEmptyLabel();
                }
            }
        }
    }
}

