/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing.desktop;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.OSType;

public class ToolBar
extends JToolBar {
    private static final String TOOLBAR_TOGGLE = "ToolBarToggle";
    private static final String TOOLBAR_TEXT = "ToolBarText";
    private static final String TOOLBAR_LARGE = "ToolBarLarge";
    private JFrame frame;
    private transient ActionFactory actions;
    private static final long serialVersionUID = 3544669594414690871L;

    public ToolBar(JFrame frame) {
        this.frame = frame;
        this.actions = new ActionFactory(ToolBar.class, this);
        this.setRollover(true);
        if (OSType.MAC.equals((Object)OSType.getOSType())) {
            this.setFloatable(false);
        }
        GuiUtil.applyDefaultOrientation(this);
    }

    public void showToolBar(boolean show) {
        Container contentPane = this.frame.getContentPane();
        if (show) {
            if (this.getOrientation() == 0) {
                contentPane.add((Component)this, "North");
            } else {
                contentPane.add((Component)this, "Before");
            }
        } else {
            contentPane.remove(this);
        }
        this.frame.validate();
    }

    public void showText(boolean show) {
        int i = 0;
        Component c = this.getComponentAtIndex(0);
        while (c != null) {
            if (c instanceof JButton) {
                JButton button = (JButton)c;
                if (show) {
                    Action action = button.getAction();
                    button.setText((String)action.getValue("ShortDescription"));
                } else {
                    button.setText(null);
                }
            }
            c = this.getComponentAtIndex(++i);
        }
    }

    public void showLargeIcons(boolean large) {
        int i = 0;
        Component c = this.getComponentAtIndex(0);
        while (c != null) {
            JButton button;
            Action action;
            if (c instanceof JButton && (action = (button = (JButton)c).getAction()) instanceof CWAction) {
                button.setDisabledIcon(null);
                if (large) {
                    button.setIcon((Icon)action.getValue("LargeIcon"));
                } else {
                    button.setIcon((Icon)action.getValue("SmallIcon"));
                }
            }
            c = this.getComponentAtIndex(++i);
        }
    }

    public JMenuItem getShowToggle() {
        JCheckBoxMenuItem toggle = new JCheckBoxMenuItem(this.actions.getAction(TOOLBAR_TOGGLE));
        toggle.setSelected(true);
        return toggle;
    }

    public JMenuItem getTextToggle() {
        return new JCheckBoxMenuItem(this.actions.getAction(TOOLBAR_TEXT));
    }

    public JMenuItem getIconSizeToggle() {
        return new JCheckBoxMenuItem(this.actions.getAction(TOOLBAR_LARGE));
    }

    public void doToolBarToggle(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        this.showToolBar(toggle.isSelected());
    }

    public void doToolBarText(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        this.showText(toggle.isSelected());
    }

    public void doToolBarLarge(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        this.showLargeIcons(toggle.isSelected());
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.actions = new ActionFactory(ToolBar.class, this);
        is.defaultReadObject();
    }
}

