/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.crosswire.common.swing.Actionable;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.OSType;
import org.crosswire.common.util.StringUtil;

public class ActionFactory
implements ActionListener,
Actionable {
    private static final String MISSING_RESOURCE = "Missing Resource";
    private static final String METHOD_PREFIX = "do";
    private static final String SEPARATOR = ".";
    private static final String TEST = ".Name";
    private Object bean;
    private static final String ALIASES = "Aliases";
    private static final String ALIAS = "Alias.";
    private static final Logger log;
    private static ResourceBundle aliases;
    private Map actions = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ActionFactory(Class type, Object bean) {
        this.buildActionMap(type);
        this.bean = bean;
    }

    public void actionPerformed(String action) {
        Action act = this.getAction(action);
        act.actionPerformed(new ActionEvent(this, 0, action));
    }

    public void actionPerformed(ActionEvent ev) {
        String action = ev.getActionCommand();
        if (!$assertionsDisabled && action == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && action.length() == 0) {
            throw new AssertionError();
        }
        String methodName = METHOD_PREFIX + action;
        Exception ex = null;
        try {
            try {
                Method doMethod = this.bean.getClass().getDeclaredMethod(methodName, ActionEvent.class);
                doMethod.invoke(this.bean, ev);
            }
            catch (NoSuchMethodException e) {
                Method doMethod = this.bean.getClass().getDeclaredMethod(methodName, new Class[0]);
                doMethod.invoke(this.bean, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        if (ex != null) {
            log.error("Could not execute method " + this.bean.getClass().getName() + SEPARATOR + methodName + "()", (Throwable)ex);
        }
    }

    public Action getAction(String key) {
        return this.getAction(key, null);
    }

    public Action getAction(String key, ActionListener listener) {
        CWAction action = (CWAction)this.actions.get(key);
        if (action != null) {
            if (listener != null) {
                action = (CWAction)action.clone();
                action.addActionListener(listener);
            }
            return action;
        }
        log.info("Missing key: '" + key + "'. Known keys are: " + StringUtil.join((Object[])this.actions.keySet().toArray(), (String)", "));
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        CWAction getOutOfJailFreeAction = new CWAction();
        getOutOfJailFreeAction.putValue("Name", key);
        getOutOfJailFreeAction.putValue("ShortDescription", MISSING_RESOURCE);
        getOutOfJailFreeAction.setEnabled(true);
        getOutOfJailFreeAction.addActionListener(this);
        return getOutOfJailFreeAction;
    }

    public JLabel createJLabel(String key) {
        Action action = this.getAction(key);
        JLabel label = new JLabel();
        label.setText(action.getValue("Name").toString());
        Integer mnemonic = (Integer)action.getValue("MnemonicKey");
        if (mnemonic != null) {
            label.setDisplayedMnemonic(mnemonic);
        }
        return label;
    }

    public JButton createActionIcon(String key) {
        return this.createActionIcon(key, null);
    }

    public JButton createActionIcon(String key, ActionListener listener) {
        Action action = this.getAction(key, listener);
        JButton button = new JButton(action);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setText(null);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    public JButton createJButton(String key) {
        return this.createJButton(key, null);
    }

    public JButton createJButton(String key, ActionListener listener) {
        return new JButton(this.getAction(key, listener));
    }

    private void buildActionMap(Class basis) {
        try {
            StringBuffer basisName = new StringBuffer(basis.getName());
            ResourceBundle resources = ResourceBundle.getBundle(basisName.toString(), Locale.getDefault(), (ClassLoader)CWClassLoader.instance((Class)basis));
            ResourceBundle controls = null;
            try {
                basisName.append("_control");
                controls = ResourceBundle.getBundle(basisName.toString(), Locale.getDefault(), (ClassLoader)CWClassLoader.instance((Class)basis));
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
            Enumeration<String> en = resources.getKeys();
            while (en.hasMoreElements()) {
                String tooltip;
                String newActionName;
                String newName;
                String key = en.nextElement();
                if (!key.endsWith(TEST)) continue;
                String actionName = key.substring(0, key.length() - TEST.length());
                String name = this.getActionString(resources, actionName, "Name");
                ResourceBundle nickname = null;
                if (name.startsWith(ALIAS) && (newName = this.getActionString(aliases, newActionName = name.substring(ALIAS.length()), "Name")) != null) {
                    name = newName;
                    nickname = aliases;
                }
                if ((tooltip = this.getOptionalActionString(nickname, resources, actionName, "ToolTip")) == null) {
                    tooltip = name;
                }
                Integer mnemonic = this.getMnemonic(nickname, resources, actionName);
                KeyStroke accelerator = this.getAccelerator(nickname, resources, actionName);
                Icon smallIcon = this.getIcon(controls, actionName, "SmallIcon");
                Icon largeIcon = this.getIcon(controls, actionName, "LargeIcon");
                String enabledStr = this.getOptionalActionString(controls, actionName, "Enabled");
                boolean enabled = enabledStr == null ? true : Boolean.valueOf(enabledStr);
                CWAction cwAction = new CWAction();
                if (actionName == null || actionName.length() == 0) {
                    log.warn("Acronymn is missing for CWAction");
                } else {
                    cwAction.putValue("ActionCommandKey", actionName);
                }
                if (name == null || name.length() == 0) {
                    log.warn("Name is missing for CWAction");
                    cwAction.putValue("Name", "?");
                } else {
                    cwAction.putValue("Name", name);
                }
                cwAction.putValue("LargeIcon", largeIcon);
                cwAction.putValue("SmallIcon", smallIcon);
                cwAction.putValue("ShortDescription", tooltip);
                if (!OSType.MAC.equals((Object)OSType.getOSType())) {
                    cwAction.putValue("MnemonicKey", mnemonic);
                }
                cwAction.putValue("AcceleratorKey", accelerator);
                cwAction.setEnabled(enabled);
                cwAction.addActionListener(this);
                this.actions.put(actionName, cwAction);
            }
        }
        catch (MissingResourceException ex) {
            log.error("Missing resource for class: " + basis.getName());
            throw ex;
        }
    }

    private String getActionString(ResourceBundle resources, String actionName, String field) {
        try {
            return resources.getString(actionName + '.' + field);
        }
        catch (MissingResourceException ex) {
            log.info("Missing key for " + actionName, (Throwable)ex);
            return null;
        }
    }

    private String getOptionalActionString(ResourceBundle resources, String actionName, String field) {
        return this.getOptionalActionString(null, resources, actionName, field);
    }

    private String getOptionalActionString(ResourceBundle nicknames, ResourceBundle resources, String actionName, String field) {
        String result = null;
        try {
            if (nicknames != null) {
                result = nicknames.getString(actionName + '.' + field);
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        try {
            if (resources != null) {
                result = resources.getString(actionName + '.' + field);
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return result;
    }

    private Icon getIcon(ResourceBundle resources, String actionName, String iconName) {
        ImageIcon icon = null;
        String iconStr = this.getOptionalActionString(resources, actionName, iconName);
        if (iconStr != null && iconStr.length() > 0) {
            icon = GuiUtil.getIcon(iconStr);
        }
        return icon;
    }

    private Integer getMnemonic(ResourceBundle nicknames, ResourceBundle resources, String actionName) {
        Integer mnemonic = null;
        String mnemonicStr = this.getOptionalActionString(nicknames, resources, actionName, "MnemonicKey");
        if (mnemonicStr != null && mnemonicStr.length() > 0) {
            try {
                mnemonic = new Integer(this.getInteger(mnemonicStr));
            }
            catch (NumberFormatException ex) {
                log.warn("Could not parse integer for mnemonic of action " + actionName, (Throwable)ex);
            }
        }
        return mnemonic;
    }

    private KeyStroke getAccelerator(ResourceBundle nicknames, ResourceBundle resources, String actionName) {
        KeyStroke accelerator = null;
        String acceleratorStr = this.getOptionalActionString(nicknames, resources, actionName, "AcceleratorKey");
        if (acceleratorStr != null && acceleratorStr.length() > 0) {
            String[] modifiers = StringUtil.split((String)this.getActionString(resources, actionName, "AcceleratorKey.Modifiers"), (char)',');
            try {
                int shortcut = this.getInteger(acceleratorStr);
                int keyModifier = this.getModifier(modifiers);
                accelerator = KeyStroke.getKeyStroke(shortcut, keyModifier);
            }
            catch (NumberFormatException nfe) {
                log.warn("Could not parse integer for accelerator of action " + actionName, (Throwable)nfe);
            }
        }
        return accelerator;
    }

    private int getInteger(String str) throws NumberFormatException {
        int val = 0;
        int length = str.length();
        val = str.startsWith("0x") ? Integer.parseInt(str.substring(2), 16) : (length == 1 ? (int)str.charAt(0) : Integer.parseInt(str));
        return val;
    }

    private int getModifier(String[] modifiers) {
        int keyModifier = 0;
        for (int j = 0; j < modifiers.length; ++j) {
            String modifier = modifiers[j];
            if ("ctrl".equalsIgnoreCase(modifier)) {
                keyModifier |= Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                continue;
            }
            if ("shift".equalsIgnoreCase(modifier)) {
                keyModifier |= 1;
                continue;
            }
            if (!"alt".equalsIgnoreCase(modifier)) continue;
            keyModifier |= 8;
        }
        return keyModifier;
    }

    static {
        $assertionsDisabled = !ActionFactory.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)ActionFactory.class);
        try {
            aliases = ResourceBundle.getBundle(ALIASES, Locale.getDefault(), (ClassLoader)CWClassLoader.instance((Class)ActionFactory.class));
        }
        catch (MissingResourceException ex) {
            log.error("Tell me it isn't so. The Aliases.properties does exist!", (Throwable)ex);
        }
    }
}

