/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.study;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.study.UserMsg;

public class StrongsNumber {
    private char language;
    private short strongsNumber;
    private String part;
    private static final Pattern STRONGS_PATTERN = Pattern.compile("([GgHh])0*([1-9][0-9]*)!?([A-Za-z]+)?");
    private static final DecimalFormat ZERO_PAD = new DecimalFormat("0000");

    public StrongsNumber(String input) throws BookException {
        this.parse(input);
        this.validate();
    }

    public StrongsNumber(char language, short strongsNumber) throws BookException {
        this(language, strongsNumber, null);
    }

    public StrongsNumber(char language, short strongsNumber, String part) throws BookException {
        this.language = language;
        this.strongsNumber = strongsNumber;
        this.part = part;
        this.validate();
    }

    public String getStrongsNumber() {
        StringBuffer buf = new StringBuffer(5);
        buf.append(this.language);
        buf.append(ZERO_PAD.format(this.strongsNumber));
        return buf.toString();
    }

    public String getFullStrongsNumber() {
        StringBuffer buf = new StringBuffer(5);
        buf.append(this.language);
        buf.append(ZERO_PAD.format(this.strongsNumber));
        if (this.part != null) {
            buf.append(this.part);
        }
        return buf.toString();
    }

    public boolean isGreek() {
        return this.language == 'G';
    }

    public boolean isHebrew() {
        return this.language == 'G';
    }

    public boolean isPart() {
        return this.part != null;
    }

    public boolean isValid() {
        if (this.language == 'H' && (this.strongsNumber < 1 || this.strongsNumber > 8674)) {
            return false;
        }
        return this.language != 'G' || this.strongsNumber >= 0 && this.strongsNumber <= 5624 && this.strongsNumber != 1418 && this.strongsNumber != 2717 && this.strongsNumber < 3203 && this.strongsNumber > 3302 && this.strongsNumber != 4452;
    }

    public int hashCode() {
        int result = 31 + this.language;
        return 31 * result + this.strongsNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StrongsNumber other = (StrongsNumber)obj;
        return this.language == other.language && this.strongsNumber == other.strongsNumber;
    }

    public String toString() {
        return this.getStrongsNumber();
    }

    private void parse(String input) throws BookException {
        String text = input;
        Matcher m = STRONGS_PATTERN.matcher(text);
        if (!m.lookingAt()) {
            throw new BookException((MsgBase)UserMsg.STRONGS_ERROR_NUMBER, new Object[]{input});
        }
        String lang = m.group(1);
        this.language = lang.charAt(0);
        switch (this.language) {
            case 'g': {
                this.language = (char)71;
                break;
            }
            case 'h': {
                this.language = (char)72;
                break;
            }
        }
        this.strongsNumber = Short.parseShort(m.group(2));
        this.part = m.group(3);
    }

    private void validate() throws BookException {
        if (this.language != 'G' && this.language != 'H') {
            throw new BookException((MsgBase)UserMsg.STRONGS_ERROR_NUMBER, new Object[]{this.toString()});
        }
    }
}

