/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.bridge;

import java.util.Iterator;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;

public class BookLookup {
    private Book book;

    public BookLookup(Book book) {
        this.book = book;
    }

    public String locate(Key key) throws BookException {
        StringBuffer buf = new StringBuffer();
        Iterator iter = key.iterator();
        while (iter.hasNext()) {
            Key currentKey = (Key)iter.next();
            String osisID = currentKey.getOsisID();
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(this.book.getInitials());
            buf.append(':');
            buf.append(osisID);
            buf.append(" - ");
            String rawText = this.book.getRawText(currentKey);
            if (rawText != null && rawText.trim().length() > 0) {
                buf.append(rawText);
                continue;
            }
            buf.append("Not found");
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            BookLookup.usage();
            return;
        }
        System.err.print("BookLookup");
        for (int i = 0; i < args.length; ++i) {
            System.err.print(' ');
            System.err.print(args[i]);
        }
        System.err.print('\n');
        Book b = Books.installed().getBook(args[0]);
        if (b == null) {
            System.err.println("Book not found");
            return;
        }
        BookLookup lookup = new BookLookup(b);
        try {
            System.out.println(lookup.locate(b.getKey(args[1])));
        }
        catch (BookException e) {
            System.err.println("Error while doing lookup");
            e.printStackTrace();
        }
        catch (NoSuchKeyException e) {
            System.err.println("Error while doing lookup");
            e.printStackTrace();
        }
    }

    public static void usage() {
        System.err.println("Usage: BookLookup book key");
    }
}

