/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import java.io.IOException;
import java.util.Properties;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.ResourceUtil;

public class IndexMetadata {
    public static final String INDEX_VERSION = "Installed.Index.Version";
    public static final String LATEST_INDEX_VERSION = "Latest.Index.Version";
    public static final String LUCENE_VERSION = "Lucene.Version";
    public static final float INDEX_VERSION_1_1 = 1.1f;
    public static final float INDEX_VERSION_1_2 = 1.2f;
    private static final Logger log = Logger.getLogger((Class)IndexMetadata.class);
    private static IndexMetadata myInstance = new IndexMetadata();
    private Properties props;

    private IndexMetadata() {
        try {
            this.props = ResourceUtil.getProperties(this.getClass());
        }
        catch (IOException e) {
            log.error("Property file read error", (Throwable)e);
        }
    }

    public static IndexMetadata instance() {
        return myInstance;
    }

    public float getInstalledIndexVersion() {
        return Float.parseFloat(this.props.getProperty(INDEX_VERSION, "1.1"));
    }

    public float getLuceneVersion() {
        return Float.parseFloat(this.props.getProperty(LUCENE_VERSION));
    }

    public float getLatestIndexVersion() {
        return Float.parseFloat(this.props.getProperty(LATEST_INDEX_VERSION, "1.1"));
    }
}

