/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.crosswire.common.util.Language;
import org.crosswire.jsword.book.BookCategory;

public class ConfigEntryType
implements Serializable {
    public static final String DIRECTION_LTOR = "LtoR";
    public static final String DIRECTION_RTOL = "RtoL";
    public static final String DIRECTION_BIDI = "bidi";
    private static final String[] BLOCK_TYPE_PICKS = new String[]{"BOOK", "CHAPTER", "VERSE"};
    private static final String[] BOOLEAN_PICKS = new String[]{"true", "false"};
    private static final String[] KEY_TYPE_PICKS = new String[]{"TreeKey", "VerseKey"};
    private static final String[] CATEGORY_PICKS = new String[]{"Daily Devotional", "Glossaries", "Cults / Unorthodox / Questionable Material", "Essays", "Maps", "Images", "Biblical Texts", "Commentaries", "Lexicons / Dictionaries", "Generic Books"};
    private static final String[] COMPRESS_TYPE_PICKS = new String[]{"LZSS", "ZIP"};
    private static final String[] DIRECTION_PICKS = new String[]{"LtoR", "RtoL", "bidi"};
    private static final String[] LICENSE_PICKS = new String[]{"Public Domain", "Copyrighted", "Copyrighted; Free non-commercial distribution", "Copyrighted; Permission to distribute granted to CrossWire", "Copyrighted; Freely distributable", "Creative Commons: by-nc-nd", "Creative Commons: by-nc-sa", "Creative Commons: by-nc", "Creative Commons: by-nd", "Creative Commons: by-sa", "Creative Commons: by", "GFDL", "GPL"};
    private static final String[] ENCODING_PICKS = new String[]{"Latin-1", "UTF-8"};
    private static final String[] GLOBAL_OPTION_FILTER_PICKS = new String[]{"GBFStrongs", "GBFFootnotes", "GBFScripref", "GBFMorph", "GBFHeadings", "GBFRedLetterWords", "ThMLStrongs", "ThMLFootnotes", "ThMLScripref", "ThMLMorph", "ThMLHeadings", "ThMLVariants", "ThMLLemma", "UTF8Cantillation", "UTF8GreekAccents", "UTF8HebrewPoints", "OSISFootnotes", "OSISHeadings", "OSISLemma", "OSISMorph", "OSISRedLetterWords", "OSISRuby", "OSISScripref", "OSISStrongs"};
    private static final String[] FEATURE_PICKS = new String[]{"StrongsNumbers", "GreekDef", "HebrewDef", "GreekParse", "HebrewParse", "DailyDevotion", "Glossary", "Images"};
    private static final String[] MOD_DRV_PICKS = new String[]{"RawText", "zText", "RawCom", "RawCom4", "zCom", "HREFCom", "RawFiles", "RawLD", "RawLD4", "zLD", "RawGenBook"};
    private static final String[] SOURCE_TYPE_PICKS = new String[]{"Plaintext", "GBF", "ThML", "OSIS", "TEI"};
    public static final ConfigEntryType ABOUT = new ConfigEntryType("About"){
        private static final long serialVersionUID = 3258416110121334073L;

        public boolean allowsContinuation() {
            return true;
        }

        public boolean allowsRTF() {
            return true;
        }
    };
    public static final ConfigEntryType BLOCK_COUNT = new ConfigEntryType("BlockCount", new Integer(200)){
        private static final long serialVersionUID = 3978711675019212341L;

        public boolean isAllowed(String aValue) {
            try {
                Integer.parseInt(aValue);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public Object convert(String input) {
            try {
                return new Integer(input);
            }
            catch (NumberFormatException e) {
                return this.getDefault();
            }
        }
    };
    public static final ConfigEntryType BLOCK_TYPE = new ConfigEntryPickType("BlockType", BLOCK_TYPE_PICKS, BLOCK_TYPE_PICKS[0]);
    public static final ConfigEntryType KEY_TYPE = new ConfigEntryPickType("KeyType", KEY_TYPE_PICKS, KEY_TYPE_PICKS[0]);
    public static final ConfigEntryType CATEGORY = new ConfigEntryPickType("Category", CATEGORY_PICKS, BookCategory.OTHER){
        private static final long serialVersionUID = 3258412850174571569L;

        public Object convert(String input) {
            return BookCategory.fromString(input);
        }
    };
    public static final ConfigEntryType CIPHER_KEY = new ConfigEntryType("CipherKey");
    public static final ConfigEntryType COMPRESS_TYPE = new ConfigEntryPickType("CompressType", COMPRESS_TYPE_PICKS, COMPRESS_TYPE_PICKS[0]);
    public static final ConfigEntryType COPYRIGHT = new ConfigEntryType("Copyright"){
        private static final long serialVersionUID = 3256441412957517110L;

        public boolean allowsContinuation() {
            return true;
        }
    };
    public static final ConfigEntryType COPYRIGHT_CONTACT_ADDRESS = new ConfigEntryType("CopyrightContactAddress"){
        private static final long serialVersionUID = 3256721784077365556L;

        public boolean allowsContinuation() {
            return true;
        }

        public boolean allowsRTF() {
            return true;
        }
    };
    public static final ConfigEntryType COPYRIGHT_CONTACT_EMAIL = new ConfigEntryType("CopyrightContactEmail");
    public static final ConfigEntryType COPYRIGHT_CONTACT_NAME = new ConfigEntryType("CopyrightContactName"){
        private static final long serialVersionUID = 3257001060181620787L;

        public boolean allowsContinuation() {
            return true;
        }

        public boolean allowsRTF() {
            return true;
        }
    };
    public static final ConfigEntryType COPYRIGHT_CONTACT_NOTES = new ConfigEntryType("CopyrightContactNotes"){
        private static final long serialVersionUID = 3257001060181620787L;

        public boolean allowsContinuation() {
            return true;
        }

        public boolean allowsRTF() {
            return true;
        }
    };
    public static final ConfigEntryType COPYRIGHT_DATE = new ConfigEntryType("CopyrightDate"){
        private Pattern validDatePattern = Pattern.compile("\\d{4}(\\s*-\\s*\\d{4})?(\\s*,\\s*\\d{4}(\\s*-\\s*\\d{4})?)*");
        private static final long serialVersionUID = 3258126977217935671L;

        public boolean isAllowed(String value) {
            return this.validDatePattern.matcher(value).matches();
        }
    };
    public static final ConfigEntryType COPYRIGHT_HOLDER = new ConfigEntryType("CopyrightHolder");
    public static final ConfigEntryType COPYRIGHT_NOTES = new ConfigEntryType("CopyrightNotes"){
        private static final long serialVersionUID = 3906926794258199608L;

        public boolean allowsContinuation() {
            return true;
        }

        public boolean allowsRTF() {
            return true;
        }
    };
    public static final ConfigEntryType DATA_PATH = new ConfigEntryType("DataPath"){
        private static final long serialVersionUID = 3546926870244309296L;

        public boolean isAllowed(String value) {
            return true;
        }
    };
    public static final ConfigEntryType DESCRIPTION = new ConfigEntryType("Description");
    public static final ConfigEntryType DIRECTION = new ConfigEntryPickType("Direction", DIRECTION_PICKS, DIRECTION_PICKS[0]);
    public static final ConfigEntryType DISPLAY_LEVEL = new ConfigEntryType("DisplayLevel"){
        private static final long serialVersionUID = 3979274654953451830L;

        public boolean isAllowed(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public Object convert(String input) {
            try {
                return new Integer(input);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    };
    public static final ConfigEntryType DISTRIBUTION_LICENSE = new ConfigEntryPickType("DistributionLicense", LICENSE_PICKS, LICENSE_PICKS[0]);
    public static final ConfigEntryType DISTRIBUTION_NOTES = new ConfigEntryType("DistributionNotes"){
        private static final long serialVersionUID = 3257005453916518196L;

        public boolean allowsContinuation() {
            return true;
        }
    };
    public static final ConfigEntryType DISTRIBUTION_SOURCE = new ConfigEntryType("DistributionSource"){
        private static final long serialVersionUID = 3763093051127904307L;

        public boolean allowsContinuation() {
            return true;
        }
    };
    public static final ConfigEntryType ENCODING = new ConfigEntryPickType("Encoding", ENCODING_PICKS, ENCODING_PICKS[0]);
    public static final ConfigEntryType GLOBAL_OPTION_FILTER = new ConfigEntryPickType("GlobalOptionFilter", GLOBAL_OPTION_FILTER_PICKS){
        private static final long serialVersionUID = 3258417209599931960L;

        public boolean mayRepeat() {
            return true;
        }
    };
    public static final ConfigEntryType GLOSSARY_FROM = new ConfigEntryType("GlossaryFrom"){
        private static final long serialVersionUID = 6619179970516935818L;

        public Object convert(String input) {
            return new Language(input);
        }
    };
    public static final ConfigEntryType GLOSSARY_TO = new ConfigEntryType("GlossaryTo"){
        private static final long serialVersionUID = 3273532519245386866L;

        public Object convert(String input) {
            return new Language(input);
        }
    };
    public static final ConfigEntryType HISTORY = new ConfigEntryType("History"){
        private static final long serialVersionUID = 3979272443195830835L;

        public boolean mayRepeat() {
            return true;
        }

        public boolean reportDetails() {
            return false;
        }
    };
    public static final ConfigEntryType INSTALL_SIZE = new ConfigEntryType("InstallSize"){
        private static final long serialVersionUID = 3256720680388408370L;

        public boolean isAllowed(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public Object convert(String input) {
            try {
                return new Integer(input);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    };
    public static final ConfigEntryType FEATURE = new ConfigEntryPickType("Feature", FEATURE_PICKS){
        private static final long serialVersionUID = 3833181424051172401L;

        public boolean mayRepeat() {
            return true;
        }
    };
    public static final ConfigEntryType FONT = new ConfigEntryType("Font");
    public static final ConfigEntryType LANG = new ConfigEntryType("Lang", new Language(null)){
        private static final long serialVersionUID = 3257008752317379897L;

        public Object convert(String input) {
            return new Language(input);
        }
    };
    public static final ConfigEntryType LCSH = new ConfigEntryType("LCSH");
    public static final ConfigEntryType MOD_DRV = new ConfigEntryPickType("ModDrv", MOD_DRV_PICKS);
    public static final ConfigEntryType MINIMUM_VERSION = new ConfigEntryType("MinimumVersion", "1.5.1a");
    public static final ConfigEntryType OBSOLETES = new ConfigEntryType("Obsoletes"){
        private static final long serialVersionUID = 3258412850157400372L;

        public boolean mayRepeat() {
            return true;
        }

        public boolean reportDetails() {
            return false;
        }
    };
    public static final ConfigEntryType SOURCE_TYPE = new ConfigEntryPickType("SourceType", SOURCE_TYPE_PICKS, SOURCE_TYPE_PICKS[0]);
    public static final ConfigEntryType SWORD_VERSION_DATE = new ConfigEntryType("SwordVersionDate"){
        private Pattern validDatePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
        private static final long serialVersionUID = 3618697504682948150L;

        public boolean isAllowed(String value) {
            return this.validDatePattern.matcher(value).matches();
        }
    };
    public static final ConfigEntryType TEXT_SOURCE = new ConfigEntryType("TextSource"){
        private static final long serialVersionUID = 3258126968594772272L;

        public boolean allowsContinuation() {
            return true;
        }
    };
    public static final ConfigEntryType VERSION = new ConfigEntryType("Version", "1.0"){
        private static final long serialVersionUID = 3256443616242055221L;

        public boolean isAllowed(String aValue) {
            try {
                Float.parseFloat(aValue);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final ConfigEntryType OSIS_Q_TO_TICK = new ConfigEntryPickType("OSISqToTick", BOOLEAN_PICKS, Boolean.TRUE){
        private static final long serialVersionUID = 3258412850174373936L;

        public Object convert(String input) {
            return Boolean.valueOf(input);
        }
    };
    public static final ConfigEntryType OSIS_VERSION = new ConfigEntryType("OSISVersion", "2.0");
    public static final ConfigEntryType INITIALS = new ConfigEntrySyntheticType("Initials");
    public static final ConfigEntryType SHORT_PROMO = new ConfigEntryType("ShortPromo");
    public static final ConfigEntryType SHORT_COPYRIGHT = new ConfigEntryType("ShortCopyright");
    public static final ConfigEntryType LIBRARY_URL = new ConfigEntrySyntheticType("LibraryURL");
    public static final ConfigEntryType LOCATION_URL = new ConfigEntrySyntheticType("LocationURL");
    private String name;
    private Object defaultValue;
    private static final long serialVersionUID = 3258125873411273014L;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final ConfigEntryType[] VALUES;

    protected ConfigEntryType(String name) {
        this(name, null);
    }

    protected ConfigEntryType(String name, Object defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAllowed(String value) {
        return value != null;
    }

    public String filter(String value) {
        return value;
    }

    public boolean allowsRTF() {
        return false;
    }

    public boolean allowsContinuation() {
        return false;
    }

    public boolean mayRepeat() {
        return false;
    }

    public boolean reportDetails() {
        return true;
    }

    protected boolean hasChoices() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public Object convert(String input) {
        return input;
    }

    public static ConfigEntryType fromString(String name) {
        if (name != null) {
            if (name.startsWith(HISTORY.toString())) {
                return HISTORY;
            }
            for (int i = 0; i < VALUES.length; ++i) {
                ConfigEntryType o = VALUES[i];
                if (!name.equals(o.name)) continue;
                return o;
            }
        }
        return null;
    }

    public static ConfigEntryType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        VALUES = new ConfigEntryType[]{ABOUT, BLOCK_COUNT, BLOCK_TYPE, CATEGORY, CIPHER_KEY, COMPRESS_TYPE, COPYRIGHT, COPYRIGHT_CONTACT_ADDRESS, COPYRIGHT_CONTACT_EMAIL, COPYRIGHT_CONTACT_NAME, COPYRIGHT_CONTACT_NOTES, COPYRIGHT_DATE, COPYRIGHT_HOLDER, COPYRIGHT_NOTES, DATA_PATH, DESCRIPTION, DIRECTION, DISPLAY_LEVEL, DISTRIBUTION_LICENSE, DISTRIBUTION_NOTES, DISTRIBUTION_SOURCE, ENCODING, GLOBAL_OPTION_FILTER, GLOSSARY_FROM, GLOSSARY_TO, HISTORY, INSTALL_SIZE, FEATURE, FONT, LANG, LCSH, MOD_DRV, MINIMUM_VERSION, OBSOLETES, SOURCE_TYPE, SWORD_VERSION_DATE, TEXT_SOURCE, VERSION, OSIS_Q_TO_TICK, OSIS_VERSION, INITIALS, SHORT_PROMO, SHORT_COPYRIGHT, LOCATION_URL, KEY_TYPE};
    }

    public static class ConfigEntrySyntheticType
    extends ConfigEntryType {
        private static final long serialVersionUID = -2468890875139856087L;

        public ConfigEntrySyntheticType(String name) {
            super(name);
        }

        public boolean isSynthetic() {
            return true;
        }
    }

    public static class ConfigEntryPickType
    extends ConfigEntryType {
        private final String[] choiceArray;
        private static final long serialVersionUID = 5642668733730291463L;

        public ConfigEntryPickType(String name, String[] picks) {
            this(name, picks, null);
        }

        public ConfigEntryPickType(String name, String[] picks, Object defaultPick) {
            super(name, defaultPick);
            this.choiceArray = (String[])picks.clone();
        }

        protected boolean hasChoices() {
            return true;
        }

        public boolean isAllowed(String value) {
            for (int i = 0; i < this.choiceArray.length; ++i) {
                if (!this.choiceArray[i].equalsIgnoreCase(value)) continue;
                return true;
            }
            return false;
        }

        public String filter(String value) {
            int i;
            for (i = 0; i < this.choiceArray.length; ++i) {
                if (!this.choiceArray[i].equals(value)) continue;
                return value;
            }
            for (i = 0; i < this.choiceArray.length; ++i) {
                if (!this.choiceArray[i].equalsIgnoreCase(value)) continue;
                return this.choiceArray[i];
            }
            return value;
        }
    }
}

